/*
 * Decompiled with CFR 0.152.
 */
package io.github.jonloucks.contracts.test;

import io.github.jonloucks.contracts.api.AutoClose;
import io.github.jonloucks.contracts.api.AutoOpen;
import io.github.jonloucks.contracts.api.Promisor;
import io.github.jonloucks.contracts.api.Promisors;
import io.github.jonloucks.contracts.test.Tools;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public interface ValuePromisorTests {
    @Test
    default public void createValuePromisor_WithNullValue_Works() {
        Tools.withContracts(contracts -> {
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            Promisor promisor = promisors.createValuePromisor(null);
            Assertions.assertNotNull((Object)promisor, (String)"should not return null.");
            Assertions.assertNull((Object)promisor.demand(), (String)"promisor demand should be null.");
        });
    }

    @Test
    default public void createValuePromisor_WithSimpleValue_Works() {
        Tools.withContracts(contracts -> {
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            Promisor promisor = promisors.createValuePromisor((Object)"abc");
            Assertions.assertNotNull((Object)promisor, (String)"should not return null.");
            Tools.assertObject(promisor);
            Assertions.assertSame((Object)"abc", (Object)promisor.demand(), (String)"deliverables should match.");
        });
    }

    @Test
    default public void createValuePromisor_incrementUsage(@Mock AutoOpen deliverable) {
        Tools.withContracts(contracts -> {
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            Promisor promisor = promisors.createValuePromisor((Object)deliverable);
            Assertions.assertNotNull((Object)promisor, (String)"should not return null.");
            promisor.incrementUsage();
            Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertSame((Object)deliverable, (Object)promisor.demand(), (String)"deliverables should match."), () -> ((AutoOpen)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.never())).open()});
        });
    }

    @Test
    default public void createValuePromisor_decrementUsage(@Mock AutoClose deliverable) {
        Tools.withContracts(contracts -> {
            Promisors promisors = (Promisors)contracts.claim(Promisors.CONTRACT);
            Promisor promisor = promisors.createValuePromisor((Object)deliverable);
            Assertions.assertNotNull((Object)promisor, (String)"should not return null.");
            promisor.decrementUsage();
            Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertSame((Object)deliverable, (Object)promisor.demand(), (String)"deliverables should match."), () -> ((AutoClose)Mockito.verify((Object)deliverable, (VerificationMode)Mockito.never())).close()});
        });
    }
}

