/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault;

import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.Auth;
import io.github.jopenlibs.vault.api.Debug;
import io.github.jopenlibs.vault.api.Leases;
import io.github.jopenlibs.vault.api.Logical;
import io.github.jopenlibs.vault.api.Seal;
import io.github.jopenlibs.vault.api.database.Database;
import io.github.jopenlibs.vault.api.mounts.Mounts;
import io.github.jopenlibs.vault.api.pki.Pki;
import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.json.JsonValue;
import io.github.jopenlibs.vault.rest.Rest;
import io.github.jopenlibs.vault.rest.RestException;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Vault {
    private final VaultConfig vaultConfig;
    private Logger logger = Logger.getLogger(Vault.class.getCanonicalName());

    public Vault(VaultConfig vaultConfig) {
        this.vaultConfig = vaultConfig;
        if (this.vaultConfig.getNameSpace() != null && !this.vaultConfig.getNameSpace().isEmpty()) {
            this.logger.info(String.format("The NameSpace %s has been bound to this Vault instance. Please keep this in mind when running operations.", this.vaultConfig.getNameSpace()));
        }
        if (this.vaultConfig.getSecretsEnginePathMap().isEmpty() && this.vaultConfig.getGlobalEngineVersion() == null) {
            this.logger.info("Constructing a Vault instance with no provided Engine version, defaulting to version 2.");
            this.vaultConfig.setEngineVersion(2);
        }
    }

    public Vault(VaultConfig vaultConfig, Integer engineVersion) {
        if (engineVersion < 1 || engineVersion > 2) {
            throw new IllegalArgumentException("The Engine version must be '1' or '2', the version supplied was: '" + engineVersion + "'.");
        }
        vaultConfig.setEngineVersion(engineVersion);
        this.vaultConfig = vaultConfig;
        if (this.vaultConfig.getNameSpace() != null && !this.vaultConfig.getNameSpace().isEmpty()) {
            this.logger.info(String.format("The Namespace %s has been bound to this Vault instance. Please keep this in mind when running operations.", this.vaultConfig.getNameSpace()));
        }
    }

    public Vault(VaultConfig vaultConfig, Boolean useSecretsEnginePathMap, Integer globalFallbackVersion) throws VaultException {
        this.vaultConfig = vaultConfig;
        if (this.vaultConfig.getNameSpace() != null && !this.vaultConfig.getNameSpace().isEmpty()) {
            this.logger.info(String.format("The Namespace %s has been bound to this Vault instance. Please keep this in mind when running operations.", this.vaultConfig.getNameSpace()));
        }
        this.vaultConfig.setEngineVersion(globalFallbackVersion);
        if (useSecretsEnginePathMap.booleanValue() && this.vaultConfig.getSecretsEnginePathMap().isEmpty()) {
            try {
                this.logger.info("No secrets Engine version map was supplied, attempting to generate one.");
                Map<String, String> secretsEnginePathMap = this.collectSecretEngineVersions();
                assert (secretsEnginePathMap != null);
                this.vaultConfig.getSecretsEnginePathMap().putAll(secretsEnginePathMap);
            }
            catch (Exception e) {
                throw new VaultException(String.format("An Engine KV version map was not supplied, and unable to determine KV Engine version, due to exception: %s", e.getMessage() + ". Do you have admin rights?"));
            }
        }
    }

    public Vault withRetries(int maxRetries, int retryIntervalMilliseconds) {
        this.vaultConfig.setMaxRetries(maxRetries);
        this.vaultConfig.setRetryIntervalMilliseconds(retryIntervalMilliseconds);
        return this;
    }

    public Logical logical() {
        return new Logical(this.vaultConfig);
    }

    public Auth auth() {
        return new Auth(this.vaultConfig);
    }

    public Pki pki() {
        return new Pki(this.vaultConfig);
    }

    public Pki pki(String mountPath) {
        return new Pki(this.vaultConfig, mountPath);
    }

    public Database database() {
        return new Database(this.vaultConfig);
    }

    public Database database(String mountPath) {
        return new Database(this.vaultConfig, mountPath);
    }

    public Leases leases() {
        return new Leases(this.vaultConfig);
    }

    public Debug debug() {
        return new Debug(this.vaultConfig);
    }

    public Mounts mounts() {
        return new Mounts(this.vaultConfig);
    }

    public Seal seal() {
        return new Seal(this.vaultConfig);
    }

    private Map<String, String> collectSecretEngineVersions() {
        try {
            RestResponse restResponse = new Rest().url(this.vaultConfig.getAddress() + "/v1/sys/mounts").header("X-Vault-Token", this.vaultConfig.getToken()).header("X-Vault-Namespace", this.vaultConfig.getNameSpace()).header("X-Vault-Request", "true").connectTimeoutSeconds(this.vaultConfig.getOpenTimeout()).readTimeoutSeconds(this.vaultConfig.getReadTimeout()).sslVerification(this.vaultConfig.getSslConfig().isVerify()).sslContext(this.vaultConfig.getSslConfig().getSslContext()).get();
            if (restResponse.getStatus() != 200) {
                return null;
            }
            String jsonString = new String(restResponse.getBody(), StandardCharsets.UTF_8);
            HashMap<String, String> data = new HashMap<String, String>();
            JsonObject jsonData = Json.parse(jsonString).asObject().get("data").asObject();
            for (JsonObject.Member member : jsonData) {
                JsonValue ver;
                String name = member.getName();
                String version = "unknown";
                JsonValue options = member.getValue().asObject().get("options");
                if (options != null && options.isObject() && (ver = options.asObject().get("version")) != null && ver.isString()) {
                    version = ver.asString();
                }
                data.put(name, version);
            }
            return data;
        }
        catch (RestException e) {
            System.err.print(String.format("Unable to retrieve the KV Engine secrets, due to exception: %s", e.getMessage()));
            return null;
        }
    }

    public Map<String, String> getSecretEngineVersions() {
        return this.collectSecretEngineVersions();
    }
}

