/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api;

import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.OperationsBase;
import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.response.VaultResponse;
import io.github.jopenlibs.vault.rest.Rest;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;

public class Leases
extends OperationsBase {
    private String nameSpace;

    public Leases(VaultConfig config) {
        super(config);
        if (this.config.getNameSpace() != null && !this.config.getNameSpace().isEmpty()) {
            this.nameSpace = this.config.getNameSpace();
        }
    }

    public Leases withNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public VaultResponse revoke(String leaseId) throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/sys/leases/revoke/" + leaseId).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).put();
            if (restResponse.getStatus() != 204) {
                throw new VaultException("Expecting HTTP status 204, but instead receiving " + restResponse.getStatus(), restResponse.getStatus());
            }
            return new VaultResponse(restResponse, attempt);
        });
    }

    public VaultResponse revokePrefix(String prefix) throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/sys/revoke-prefix/" + prefix).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).put();
            if (restResponse.getStatus() != 204) {
                throw new VaultException("Expecting HTTP status 204, but instead receiving " + restResponse.getStatus(), restResponse.getStatus());
            }
            return new VaultResponse(restResponse, attempt);
        });
    }

    public VaultResponse revokeForce(String prefix) throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/sys/revoke-force/" + prefix).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).put();
            if (restResponse.getStatus() != 204) {
                throw new VaultException("Expecting HTTP status 204, but instead receiving " + restResponse.getStatus(), restResponse.getStatus());
            }
            return new VaultResponse(restResponse, attempt);
        });
    }

    public VaultResponse renew(String leaseId, long increment) throws VaultException {
        return this.retry(attempt -> {
            String requestJson = Json.object().add("increment", increment).toString();
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/sys/renew/" + leaseId).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(increment < 0L ? null : requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Expecting HTTP status 200, but instead receiving " + restResponse.getStatus(), restResponse.getStatus());
            }
            return new VaultResponse(restResponse, attempt);
        });
    }
}

