/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api;

import io.github.jopenlibs.vault.api.Logical;
import io.github.jopenlibs.vault.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class LogicalUtilities {
    private LogicalUtilities() {
    }

    private static List<String> getPathSegments(String path) {
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            segments.add(tokenizer.nextToken());
        }
        return segments;
    }

    public static String addQualifierToPath(List<String> segments, int prefixPathDepth, String qualifier) {
        int index;
        StringBuilder adjustedPath = new StringBuilder();
        for (index = 0; index < prefixPathDepth; ++index) {
            adjustedPath.append(segments.get(index)).append('/');
        }
        adjustedPath.append(qualifier);
        while (index < segments.size()) {
            adjustedPath.append('/').append(segments.get(index));
            ++index;
        }
        return adjustedPath.toString();
    }

    public static String adjustPathForReadOrWrite(String path, int prefixPathLength, Logical.logicalOperations operation) {
        List<String> pathSegments = LogicalUtilities.getPathSegments(path);
        if (operation.equals((Object)Logical.logicalOperations.readV2) || operation.equals((Object)Logical.logicalOperations.writeV2)) {
            StringBuilder adjustedPath = new StringBuilder(LogicalUtilities.addQualifierToPath(pathSegments, prefixPathLength, "data"));
            if (path.endsWith("/")) {
                adjustedPath.append("/");
            }
            return adjustedPath.toString();
        }
        return path;
    }

    public static String adjustPathForList(String path, int prefixPathDepth, Logical.logicalOperations operation) {
        List<String> pathSegments = LogicalUtilities.getPathSegments(path);
        StringBuilder adjustedPath = new StringBuilder();
        if (operation.equals((Object)Logical.logicalOperations.listV2)) {
            adjustedPath.append(LogicalUtilities.addQualifierToPath(pathSegments, prefixPathDepth, "metadata"));
            if (path.endsWith("/")) {
                adjustedPath.append("/");
            }
        } else {
            adjustedPath.append(path);
        }
        adjustedPath.append("?list=true");
        return adjustedPath.toString();
    }

    public static String adjustPathForDelete(String path, int prefixPathDepth, Logical.logicalOperations operation) {
        List<String> pathSegments = LogicalUtilities.getPathSegments(path);
        if (operation.equals((Object)Logical.logicalOperations.deleteV2)) {
            StringBuilder adjustedPath = new StringBuilder(LogicalUtilities.addQualifierToPath(pathSegments, prefixPathDepth, "metadata"));
            if (path.endsWith("/")) {
                adjustedPath.append("/");
            }
            return adjustedPath.toString();
        }
        return path;
    }

    public static String adjustPathForVersionDelete(String path, int prefixPathDepth) {
        List<String> pathSegments = LogicalUtilities.getPathSegments(path);
        StringBuilder adjustedPath = new StringBuilder(LogicalUtilities.addQualifierToPath(pathSegments, prefixPathDepth, "delete"));
        if (path.endsWith("/")) {
            adjustedPath.append("/");
        }
        return adjustedPath.toString();
    }

    public static String adjustPathForVersionUnDelete(String path, int prefixPathDepth) {
        List<String> pathSegments = LogicalUtilities.getPathSegments(path);
        StringBuilder adjustedPath = new StringBuilder(LogicalUtilities.addQualifierToPath(pathSegments, prefixPathDepth, "undelete"));
        if (path.endsWith("/")) {
            adjustedPath.append("/");
        }
        return adjustedPath.toString();
    }

    public static String adjustPathForVersionDestroy(String path, int prefixPathDepth) {
        List<String> pathSegments = LogicalUtilities.getPathSegments(path);
        StringBuilder adjustedPath = new StringBuilder(LogicalUtilities.addQualifierToPath(pathSegments, prefixPathDepth, "destroy"));
        if (path.endsWith("/")) {
            adjustedPath.append("/");
        }
        return adjustedPath.toString();
    }

    public static JsonObject jsonObjectToWriteFromEngineVersion(Logical.logicalOperations operation, JsonObject jsonObject) {
        if (operation.equals((Object)Logical.logicalOperations.writeV2)) {
            JsonObject wrappedJson = new JsonObject();
            wrappedJson.add("data", jsonObject);
            return wrappedJson;
        }
        return jsonObject;
    }
}

