/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api.mounts;

import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.OperationsBase;
import io.github.jopenlibs.vault.api.mounts.MountPayload;
import io.github.jopenlibs.vault.api.mounts.MountType;
import io.github.jopenlibs.vault.response.MountResponse;
import io.github.jopenlibs.vault.rest.Rest;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;

public class Mounts
extends OperationsBase {
    public Mounts(VaultConfig config) {
        super(config);
    }

    public MountResponse list() throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(String.format("%s/v1/sys/mounts", this.config.getAddress())).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
            if (restResponse.getStatus() != 200) {
                String body = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + body, restResponse.getStatus());
            }
            return new MountResponse(restResponse, attempt, true);
        });
    }

    public MountResponse enable(String path, MountType type, MountPayload payload) throws VaultException {
        if (type == null) {
            throw new VaultException("Mount type is missing");
        }
        if (payload == null) {
            throw new VaultException("MountPayload is missing");
        }
        return this.retry(attempt -> {
            String requestJson = payload.toEnableJson(type).toString();
            RestResponse restResponse = new Rest().url(String.format("%s/v1/sys/mounts/%s", this.config.getAddress(), path)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 204) {
                String body = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + body, restResponse.getStatus());
            }
            return new MountResponse(restResponse, attempt, false);
        });
    }

    public MountResponse disable(String path) throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(String.format("%s/v1/sys/mounts/%s", this.config.getAddress(), path)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).delete();
            if (restResponse.getStatus() != 204) {
                String body = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + body, restResponse.getStatus());
            }
            return new MountResponse(restResponse, attempt, false);
        });
    }

    public MountResponse read(String path) throws VaultException {
        return this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(String.format("%s/v1/sys/mounts/%s/tune", this.config.getAddress(), path)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
            if (restResponse.getStatus() != 200 && restResponse.getStatus() != 404) {
                String body = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + body, restResponse.getStatus());
            }
            return new MountResponse(restResponse, attempt, false);
        });
    }

    public MountResponse tune(String path, MountPayload payload) throws VaultException {
        return this.retry(attempt -> {
            if (payload == null) {
                throw new VaultException("MountPayload is missing");
            }
            String requestJson = payload.toTuneJson().toString();
            RestResponse restResponse = new Rest().url(String.format("%s/v1/sys/mounts/%s/tune", this.config.getAddress(), path)).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 204) {
                String body = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + body, restResponse.getStatus());
            }
            return new MountResponse(restResponse, attempt, false);
        });
    }
}

