/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api;

import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.OperationsBase;
import io.github.jopenlibs.vault.api.sys.Sys;
import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.response.AuthResponse;
import io.github.jopenlibs.vault.response.LogicalResponse;
import io.github.jopenlibs.vault.response.LookupResponse;
import io.github.jopenlibs.vault.response.UnwrapResponse;
import io.github.jopenlibs.vault.response.WrapResponse;
import io.github.jopenlibs.vault.rest.Rest;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Auth
extends OperationsBase {
    private String nameSpace;

    public Auth(VaultConfig config) {
        super(config);
        if (this.config.getNameSpace() != null && !this.config.getNameSpace().isEmpty()) {
            this.nameSpace = this.config.getNameSpace();
        }
    }

    public Auth withNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public AuthResponse createToken(TokenRequest tokenRequest) throws VaultException {
        return this.createToken(tokenRequest, "token");
    }

    public AuthResponse createToken(TokenRequest tokenRequest, String tokenAuthMount) throws VaultException {
        String mount = tokenAuthMount != null ? tokenAuthMount : "token";
        return this.retry(attempt -> {
            String mimeType;
            String url;
            RestResponse restResponse;
            JsonObject jsonObject = Json.object();
            if (tokenRequest.getId() != null) {
                jsonObject.add("id", tokenRequest.getId().toString());
            }
            if (tokenRequest.getPolices() != null && !tokenRequest.getPolices().isEmpty()) {
                jsonObject.add("policies", Json.array(tokenRequest.getPolices().toArray(new String[0])));
            }
            if (tokenRequest.getMeta() != null && !tokenRequest.getMeta().isEmpty()) {
                JsonObject metaMap = Json.object();
                for (Map.Entry<String, String> entry : tokenRequest.getMeta().entrySet()) {
                    metaMap.add(entry.getKey(), entry.getValue());
                }
                jsonObject.add("meta", metaMap);
            }
            if (tokenRequest.getNoParent() != null) {
                jsonObject.add("no_parent", tokenRequest.getNoParent());
            }
            if (tokenRequest.getNoDefaultPolicy() != null) {
                jsonObject.add("no_default_policy", tokenRequest.getNoDefaultPolicy());
            }
            if (tokenRequest.getTtl() != null) {
                jsonObject.add("ttl", tokenRequest.getTtl());
            }
            if (tokenRequest.getDisplayName() != null) {
                jsonObject.add("display_name", tokenRequest.getDisplayName());
            }
            if (tokenRequest.getNumUses() != null) {
                jsonObject.add("num_uses", tokenRequest.getNumUses());
            }
            if (tokenRequest.getRenewable() != null) {
                jsonObject.add("renewable", tokenRequest.getRenewable());
            }
            if (tokenRequest.getType() != null) {
                jsonObject.add("type", tokenRequest.getType());
            }
            if (tokenRequest.getExplicitMaxTtl() != null) {
                jsonObject.add("explicit_max_ttl", tokenRequest.getExplicitMaxTtl());
            }
            if (tokenRequest.getPeriod() != null) {
                jsonObject.add("period", tokenRequest.getPeriod());
            }
            if (tokenRequest.getEntityAlias() != null) {
                jsonObject.add("entity_alias", tokenRequest.getEntityAlias());
            }
            String requestJson = jsonObject.toString();
            StringBuilder urlBuilder = new StringBuilder(this.config.getAddress()).append("/v1/auth/").append(mount).append("/create");
            if (tokenRequest.getRole() != null) {
                urlBuilder.append("/").append(tokenRequest.getRole());
            }
            if ((restResponse = new Rest().url(url = urlBuilder.toString()).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post()).getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new AuthResponse(restResponse, attempt);
        });
    }

    @Deprecated
    public AuthResponse loginByAppID(String path, String appId, String userId) throws VaultException {
        return this.retry(attempt -> {
            String mimeType;
            String requestJson = Json.object().add("app_id", appId).add("user_id", userId).toString();
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + path).header("X-Vault-Namespace", this.nameSpace).body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new AuthResponse(restResponse, attempt);
        });
    }

    public AuthResponse loginByAppRole(String roleId, String secretId) throws VaultException {
        return this.loginByAppRole("approle", roleId, secretId);
    }

    public AuthResponse loginByAppRole(String path, String roleId, String secretId) throws VaultException {
        return this.retry(attempt -> {
            String mimeType;
            String requestJson = Json.object().add("role_id", roleId).add("secret_id", secretId).toString();
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + path + "/login").header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new AuthResponse(restResponse, attempt);
        });
    }

    public AuthResponse loginByUserPass(String username, String password) throws VaultException {
        return this.loginByUserPass(username, password, "userpass");
    }

    public AuthResponse loginByUserPass(String username, String password, String userpassAuthMount) throws VaultException {
        String mount = userpassAuthMount != null ? userpassAuthMount : "userpass";
        return this.retry(attempt -> {
            String mimeType;
            String requestJson = Json.object().add("password", password).toString();
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/login/" + username).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new AuthResponse(restResponse, attempt);
        });
    }

    public AuthResponse loginByLDAP(String username, String password) throws VaultException {
        return this.loginByLDAP(username, password, "ldap");
    }

    public AuthResponse loginByLDAP(String username, String password, String ldapAuthMount) throws VaultException {
        String mount = ldapAuthMount != null ? ldapAuthMount : "ldap";
        return this.loginByUserPass(username, password, mount);
    }

    public AuthResponse loginByAwsEc2(String role, String identity, String signature, String nonce, String awsAuthMount) throws VaultException {
        String mount = awsAuthMount != null ? awsAuthMount : "aws";
        return this.retry(attempt -> {
            String mimeType;
            JsonObject request = Json.object().add("identity", identity).add("signature", signature);
            if (role != null) {
                request.add("role", role);
            }
            if (nonce != null) {
                request.add("nonce", nonce);
            }
            String requestJson = request.toString();
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/login").body(requestJson.getBytes(StandardCharsets.UTF_8)).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new AuthResponse(restResponse, attempt);
        });
    }

    public AuthResponse loginByAwsEc2(String role, String pkcs7, String nonce, String awsAuthMount) throws VaultException {
        String mount = awsAuthMount != null ? awsAuthMount : "aws";
        return this.retry(attempt -> {
            String mimeType;
            JsonObject request = Json.object().add("pkcs7", pkcs7);
            if (role != null) {
                request.add("role", role);
            }
            if (nonce != null) {
                request.add("nonce", nonce);
            }
            String requestJson = request.toString();
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/login").header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new AuthResponse(restResponse, attempt);
        });
    }

    public AuthResponse loginByAwsIam(String role, String iamRequestUrl, String iamRequestBody, String iamRequestHeaders, String awsAuthMount) throws VaultException {
        String mount = awsAuthMount != null ? awsAuthMount : "aws";
        return this.retry(attempt -> {
            String mimeType;
            JsonObject request = Json.object().add("iam_request_url", iamRequestUrl).add("iam_request_body", iamRequestBody).add("iam_request_headers", iamRequestHeaders).add("iam_http_request_method", "POST");
            if (role != null) {
                request.add("role", role);
            }
            String requestJson = request.toString();
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/login").header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new AuthResponse(restResponse, attempt);
        });
    }

    public AuthResponse loginByGithub(String githubToken) throws VaultException {
        return this.loginByGithub(githubToken, "github");
    }

    public AuthResponse loginByGithub(String githubToken, String githubAuthMount) throws VaultException {
        String mount = githubAuthMount != null ? githubAuthMount : "github";
        return this.retry(attempt -> {
            String mimeType;
            String requestJson = Json.object().add("token", githubToken).toString();
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/login").header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new AuthResponse(restResponse, attempt);
        });
    }

    public AuthResponse loginByJwt(String provider, String role, String jwt) throws VaultException {
        return this.loginByJwt(provider, role, jwt, "auth/" + provider);
    }

    public AuthResponse loginByJwt(String provider, String role, String jwt, String authPath) throws VaultException {
        return this.retry(attempt -> {
            String mimeType;
            String requestJson = Json.object().add("role", role).add("jwt", jwt).toString();
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/" + authPath + "/login").header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new AuthResponse(restResponse, attempt);
        });
    }

    public AuthResponse loginByGCP(String role, String jwt) throws VaultException {
        return this.loginByJwt("gcp", role, jwt);
    }

    public AuthResponse loginByKubernetes(String role, String jwt) throws VaultException {
        return this.loginByJwt("kubernetes", role, jwt);
    }

    public AuthResponse loginByKubernetes(String role, String jwt, String authPath) throws VaultException {
        return this.loginByJwt("kubernetes", role, jwt, authPath);
    }

    public AuthResponse loginByCert() throws VaultException {
        return this.loginByCert("cert");
    }

    public AuthResponse loginByCert(String certAuthMount) throws VaultException {
        String mount = certAuthMount != null ? certAuthMount : "cert";
        return this.retry(attempt -> {
            String mimeType;
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/login").header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new AuthResponse(restResponse, attempt);
        });
    }

    public AuthResponse renewSelf() throws VaultException {
        return this.renewSelf(-1L);
    }

    public AuthResponse renewSelf(long increment) throws VaultException {
        return this.renewSelf(increment, "token");
    }

    public AuthResponse renewSelf(long increment, String tokenAuthMount) throws VaultException {
        String mount = tokenAuthMount != null ? tokenAuthMount : "token";
        return this.retry(attempt -> {
            String mimeType;
            String requestJson = Json.object().add("increment", increment).toString();
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/renew-self").header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(increment < 0L ? null : requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new AuthResponse(restResponse, attempt);
        });
    }

    public LookupResponse lookupSelf() throws VaultException {
        return this.lookupSelf("token");
    }

    public LookupResponse lookupSelf(String tokenAuthMount) throws VaultException {
        String mount = tokenAuthMount != null ? tokenAuthMount : "token";
        return this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/lookup-self").header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String mimeType = restResponse.getMimeType();
            if (!"application/json".equals(mimeType)) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new LookupResponse(restResponse, attempt);
        });
    }

    public LogicalResponse lookupWrap() throws VaultException {
        Sys sys = new Sys(this.config);
        return sys.wrapping().lookupWrap(this.config.getToken(), false);
    }

    public LogicalResponse lookupWrap(String wrappedToken) throws VaultException {
        Sys sys = new Sys(this.config);
        return sys.wrapping().lookupWrap(wrappedToken, true);
    }

    public LogicalResponse lookupWrap(String wrappedToken, boolean inBody) throws VaultException {
        Sys sys = new Sys(this.config);
        return sys.wrapping().lookupWrap(wrappedToken, inBody);
    }

    public void revokeSelf() throws VaultException {
        this.revokeSelf("token");
    }

    public void revokeSelf(String tokenAuthMount) throws VaultException {
        String mount = tokenAuthMount != null ? tokenAuthMount : "token";
        this.retry(attempt -> {
            RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/revoke-self").header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 204) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            return null;
        });
    }

    public UnwrapResponse unwrap() throws VaultException {
        Sys sys = new Sys(this.config);
        return sys.wrapping().unwrap(this.config.getToken(), false);
    }

    public UnwrapResponse unwrap(String wrappedToken) throws VaultException {
        Sys sys = new Sys(this.config);
        return sys.wrapping().unwrap(wrappedToken, true);
    }

    public UnwrapResponse unwrap(String wrappedToken, boolean inBody) throws VaultException {
        Sys sys = new Sys(this.config);
        return sys.wrapping().unwrap(wrappedToken, inBody);
    }

    public WrapResponse wrap(JsonObject jsonObject, int ttlInSec) throws VaultException {
        Sys sys = new Sys(this.config);
        return sys.wrapping().wrap(jsonObject, ttlInSec);
    }

    public WrapResponse rewrap(String wrappedToken) throws VaultException {
        Sys sys = new Sys(this.config);
        return sys.wrapping().rewrap(wrappedToken);
    }

    public static class TokenRequest
    implements Serializable {
        private UUID id;
        private List<String> polices;
        private Map<String, String> meta;
        private Boolean noParent;
        private Boolean noDefaultPolicy;
        private String ttl;
        private String displayName;
        private Long numUses;
        private String role;
        private Boolean renewable;
        private String type;
        private String explicitMaxTtl;
        private String period;
        private String entityAlias;

        public TokenRequest id(UUID id) {
            this.id = id;
            return this;
        }

        public TokenRequest polices(List<String> polices) {
            this.polices = polices;
            return this;
        }

        public TokenRequest meta(Map<String, String> meta) {
            this.meta = meta;
            return this;
        }

        public TokenRequest noParent(Boolean noParent) {
            this.noParent = noParent;
            return this;
        }

        public TokenRequest noDefaultPolicy(Boolean noDefaultPolicy) {
            this.noDefaultPolicy = noDefaultPolicy;
            return this;
        }

        public TokenRequest ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public TokenRequest displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public TokenRequest numUses(Long numUses) {
            this.numUses = numUses;
            return this;
        }

        public TokenRequest role(String role) {
            this.role = role;
            return this;
        }

        public TokenRequest renewable(Boolean renewable) {
            this.renewable = renewable;
            return this;
        }

        public TokenRequest type(String type) {
            this.type = type;
            return this;
        }

        public TokenRequest explicitMaxTtl(String explicitMaxTtl) {
            this.explicitMaxTtl = explicitMaxTtl;
            return this;
        }

        public TokenRequest period(String period) {
            this.period = period;
            return this;
        }

        public TokenRequest entityAlias(String entityAlias) {
            this.entityAlias = entityAlias;
            return this;
        }

        public UUID getId() {
            return this.id;
        }

        public List<String> getPolices() {
            return this.polices;
        }

        public Map<String, String> getMeta() {
            return this.meta;
        }

        public Boolean getNoParent() {
            return this.noParent;
        }

        public Boolean getNoDefaultPolicy() {
            return this.noDefaultPolicy;
        }

        public String getTtl() {
            return this.ttl;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Long getNumUses() {
            return this.numUses;
        }

        public String getRole() {
            return this.role;
        }

        public Boolean getRenewable() {
            return this.renewable;
        }

        public String getType() {
            return this.type;
        }

        public String getExplicitMaxTtl() {
            return this.explicitMaxTtl;
        }

        public String getPeriod() {
            return this.period;
        }

        public String getEntityAlias() {
            return this.entityAlias;
        }
    }
}

