/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api.sys;

import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.Logical;
import io.github.jopenlibs.vault.api.OperationsBase;
import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.response.LogicalResponse;
import io.github.jopenlibs.vault.response.UnwrapResponse;
import io.github.jopenlibs.vault.response.WrapResponse;
import io.github.jopenlibs.vault.rest.Rest;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class Wrapping
extends OperationsBase {
    private String nameSpace;

    public Wrapping(VaultConfig config) {
        super(config);
        if (this.config.getNameSpace() != null && !this.config.getNameSpace().isEmpty()) {
            this.nameSpace = this.config.getNameSpace();
        }
    }

    public LogicalResponse lookupWrap() throws VaultException {
        return this.lookupWrap(this.config.getToken(), false);
    }

    public LogicalResponse lookupWrap(String wrappedToken) throws VaultException {
        return this.lookupWrap(wrappedToken, true);
    }

    public LogicalResponse lookupWrap(String wrappedToken, boolean inBody) throws VaultException {
        String requestJson = inBody ? Json.object().add("token", wrappedToken).toString() : null;
        return this.retry(attempt -> {
            Rest rest = new Rest().url(this.config.getAddress() + "/v1/sys/wrapping/lookup").header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext());
            rest = inBody ? rest.header("X-Vault-Token", this.config.getToken()).body(requestJson.getBytes(StandardCharsets.UTF_8)) : rest.header("X-Vault-Token", wrappedToken);
            RestResponse restResponse = rest.post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String mimeType = restResponse.getMimeType();
            if (!"application/json".equals(mimeType)) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new LogicalResponse(restResponse, attempt, Logical.logicalOperations.authentication);
        });
    }

    public WrapResponse wrap(JsonObject jsonObject, int ttlInSec) throws VaultException {
        Objects.requireNonNull(jsonObject);
        return this.retry(attempt -> {
            String mimeType;
            String requestJson = jsonObject.toString();
            String url = this.config.getAddress() + "/v1/sys/wrapping/wrap";
            RestResponse restResponse = new Rest().url(url).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Wrap-TTL", Integer.toString(ttlInSec)).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new WrapResponse(restResponse, attempt);
        });
    }

    public UnwrapResponse unwrap() throws VaultException {
        return this.unwrap(this.config.getToken(), false);
    }

    public UnwrapResponse unwrap(String wrappedToken) throws VaultException {
        return this.unwrap(wrappedToken, true);
    }

    public UnwrapResponse unwrap(String wrappedToken, boolean inBody) throws VaultException {
        Objects.requireNonNull(wrappedToken, "Wrapped token is null");
        return this.retry(attempt -> {
            String mimeType;
            String url = this.config.getAddress() + "/v1/sys/wrapping/unwrap";
            Rest rest = new Rest().url(url).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext());
            if (inBody) {
                String requestJson = Json.object().add("token", wrappedToken).toString();
                rest = rest.header("X-Vault-Token", this.config.getToken()).body(requestJson.getBytes(StandardCharsets.UTF_8));
            } else {
                rest = rest.header("X-Vault-Token", wrappedToken);
            }
            RestResponse restResponse = rest.post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new UnwrapResponse(restResponse, attempt);
        });
    }

    public WrapResponse rewrap(String wrappedToken) throws VaultException {
        Objects.requireNonNull(wrappedToken);
        return this.retry(attempt -> {
            String mimeType;
            String requestJson = Json.object().add("token", wrappedToken).toString();
            String url = this.config.getAddress() + "/v1/sys/wrapping/rewrap";
            RestResponse restResponse = new Rest().url(url).header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
            if (restResponse.getStatus() != 200) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), StandardCharsets.UTF_8), restResponse.getStatus());
            }
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            return new WrapResponse(restResponse, attempt);
        });
    }
}

