/*
 * Decompiled with CFR 0.152.
 */
package io.github.jponge.vertx.boot;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.stream.Collectors;

public class BootVerticle
extends AbstractVerticle {
    private static final String VERTX_BOOT_VERTICLES_PATH = "vertx-boot.verticles";
    private static final String CONF_KEY = "configuration";
    private static final String INSTANCES_KEY = "instances";
    private static final String EXTRA_CLASSPATH_KEY = "extra-classpath";
    private static final String HA_KEY = "high-availability";
    private static final String ISOLATED_CLASSES_KEY = "isolated-classes";
    private static final String ISOLATION_GROUP_KEY = "isolation-group";
    private static final String MAXWORKER_EXECTIME_KEY = "max-worker-execution-time";
    private static final String WORKER_KEY = "worker";
    private static final String WORKER_POOLNAME_KEY = "worker-pool-name";
    private static final String WORKER_POOLSIZE_KEY = "worker-pool-size";

    public void start(Promise<Void> promise) {
        try {
            Config bootConfig = ConfigFactory.load();
            List configList = bootConfig.getConfig(VERTX_BOOT_VERTICLES_PATH).root().keySet().stream().map(key -> bootConfig.getConfig("vertx-boot.verticles." + key)).collect(Collectors.toList());
            List futures = configList.stream().map(this::deployVerticle).collect(Collectors.toList());
            CompositeFuture.all(futures).onComplete(ar -> {
                if (ar.succeeded()) {
                    promise.complete();
                } else {
                    promise.fail(ar.cause());
                }
            });
        }
        catch (Throwable t) {
            promise.fail(t);
        }
    }

    private Future<String> deployVerticle(Config config) {
        Promise promise = Promise.promise();
        try {
            String name = config.getString("name");
            DeploymentOptions options = new DeploymentOptions().setInstances(this.getInstances(config)).setConfig(this.getConfig(config)).setExtraClasspath(this.getExtraClasspath(config)).setHa(this.getHa(config)).setIsolatedClasses(this.getIsolatedClasses(config)).setIsolationGroup(this.getIsolationGroup(config)).setMaxWorkerExecuteTime(this.getMaxWorkerExecuteTime(config)).setWorker(this.getWorker(config)).setWorkerPoolName(this.getWorkerPoolName(config)).setWorkerPoolSize(this.getWorkerPoolSize(config));
            this.vertx.deployVerticle(name, options, ar -> {
                if (ar.succeeded()) {
                    promise.complete(ar.result());
                } else {
                    promise.fail(ar.cause());
                }
            });
        }
        catch (Throwable t) {
            promise.fail(t);
        }
        return promise.future();
    }

    private int getWorkerPoolSize(Config config) {
        if (config.hasPath(WORKER_POOLSIZE_KEY)) {
            return config.getInt(WORKER_POOLSIZE_KEY);
        }
        return 1;
    }

    private String getWorkerPoolName(Config config) {
        if (config.hasPath(WORKER_POOLNAME_KEY)) {
            return config.getString(WORKER_POOLNAME_KEY);
        }
        return null;
    }

    private boolean getWorker(Config config) {
        if (config.hasPath(WORKER_KEY)) {
            return config.getBoolean(WORKER_KEY);
        }
        return false;
    }

    private long getMaxWorkerExecuteTime(Config config) {
        if (config.hasPath(MAXWORKER_EXECTIME_KEY)) {
            return config.getLong(MAXWORKER_EXECTIME_KEY);
        }
        return Long.MAX_VALUE;
    }

    private String getIsolationGroup(Config config) {
        if (config.hasPath(ISOLATION_GROUP_KEY)) {
            return config.getString(ISOLATION_GROUP_KEY);
        }
        return null;
    }

    private List<String> getIsolatedClasses(Config config) {
        if (config.hasPath(ISOLATED_CLASSES_KEY)) {
            return config.getStringList(ISOLATED_CLASSES_KEY);
        }
        return null;
    }

    private boolean getHa(Config config) {
        if (config.hasPath(HA_KEY)) {
            return config.getBoolean(HA_KEY);
        }
        return false;
    }

    private List<String> getExtraClasspath(Config config) {
        if (config.hasPath(EXTRA_CLASSPATH_KEY)) {
            return config.getStringList(EXTRA_CLASSPATH_KEY);
        }
        return null;
    }

    private JsonObject getConfig(Config config) {
        if (config.hasPath(CONF_KEY)) {
            return new JsonObject(config.getValue(CONF_KEY).render(ConfigRenderOptions.concise()));
        }
        return new JsonObject();
    }

    private int getInstances(Config config) {
        if (config.hasPath(INSTANCES_KEY)) {
            return config.getInt(INSTANCES_KEY);
        }
        return 1;
    }
}

