/*
 * Decompiled with CFR 0.152.
 */
package juuxel.unionrelauncher;

import cpw.mods.jarhandling.SecureJar;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class UnionRelauncher {
    private static final String MAIN_CLASS_PROPERTY = "unionRelauncher.mainClass";
    private static final String MOD_CLASSES_ENV = "MOD_CLASSES";

    private UnionRelauncher() {
    }

    public static void main(String[] args) throws Throwable {
        String mainClassName = Objects.requireNonNull(System.getProperty(MAIN_CLASS_PROPERTY), "no main class defined");
        String modClasses = Objects.requireNonNullElse(System.getenv(MOD_CLASSES_ENV), "");
        record ModPathEntry(String mod, Path path) {
        }
        Map<String, List<ModPathEntry>> mods = Arrays.stream(modClasses.split(File.pathSeparator)).map(line -> line.split("%%", 2)).map(parts -> {
            String mod = ((String[])parts).length == 1 ? "defaultmodid" : parts[0];
            Path path = Path.of(parts[((String[])parts).length - 1], new String[0]);
            return new ModPathEntry(mod, path);
        }).collect(Collectors.groupingBy(ModPathEntry::mod));
        Set allModUris = mods.values().stream().flatMap(entries -> entries.stream().map(ModPathEntry::path)).map(Path::toUri).collect(Collectors.toSet());
        Set filteredClasspath = Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).map(Path::toUri).filter(uri -> !allModUris.contains(uri)).collect(Collectors.toSet());
        Set modUris = mods.values().stream().map(entries -> (Path[])entries.stream().map(ModPathEntry::path).toArray(Path[]::new)).map(SecureJar::from).map(SecureJar::getRootPath).map(Path::toUri).collect(Collectors.toSet());
        URL[] urlClasspath = (URL[])Stream.concat(filteredClasspath.stream(), modUris.stream()).map(uri -> {
            try {
                return uri.toURL();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).toArray(URL[]::new);
        URLClassLoader urlClassLoader = new URLClassLoader(urlClasspath, null);
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        Class<?> mainClass = Class.forName(mainClassName, true, urlClassLoader);
        MethodHandles.publicLookup().findStatic(mainClass, "main", MethodType.methodType(Void.TYPE, String[].class)).invokeExact(args);
    }
}

