/*
 * Decompiled with CFR 0.152.
 */
package juuxel.unprotect;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

final class CloseableContainer<T extends Closeable>
implements Closeable {
    final T value;
    private final Closeable[] dependencies;

    private CloseableContainer(T value, Closeable ... dependencies) {
        this.value = value;
        this.dependencies = Arrays.copyOf(dependencies, dependencies.length);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    @Nullable
    static <T extends Closeable> CloseableContainer<T> of(@Nullable T value, Closeable ... dependencies) {
        return value != null ? new CloseableContainer<T>(value, dependencies) : null;
    }

    @Override
    public void close() throws IOException {
        @Nullable IOException top = null;
        try {
            this.value.close();
        }
        catch (IOException e) {
            top = e;
        }
        for (Closeable dependency : this.dependencies) {
            try {
                dependency.close();
            }
            catch (IOException e) {
                if (top == null) {
                    top = e;
                    continue;
                }
                top.addSuppressed(e);
            }
        }
        if (top != null) {
            throw top;
        }
    }
}

