/*
 * Decompiled with CFR 0.152.
 */
package juuxel.unprotect;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import juuxel.unprotect.CloseableContainer;
import juuxel.unprotect.Transformation;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

final class TargetCache {
    private static final String TINY_2_0_PREFIX = "tiny\t2\t0\t";
    private static final String CLASS_PREFIX = "c\t";
    @Nullable
    private final Set<String> minecraftClasses = this.loadClasses();

    TargetCache() {
        if (this.minecraftClasses == null) {
            Transformation.LOGGER.warn("Could not load mappings from classpath, falling back to checking packages");
        } else {
            Transformation.LOGGER.info("Found {} Minecraft classes", (Object)this.minecraftClasses.size());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Set<String> loadClasses() {
        try (@Nullable CloseableContainer<InputStream> in = this.getMappingStream();){
            Set<String> set;
            if (in == null) {
                Transformation.LOGGER.warn("Mappings not available! (mappings/mappings.tiny in {})", (Object)System.getProperty("unprotect.mappings", "classpath"));
                Set<String> set2 = null;
                return set2;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in.value));){
                set = this.loadClasses(reader);
            }
            return set;
        }
        catch (IOException e) {
            Transformation.LOGGER.error("Could not load mappings", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private CloseableContainer<InputStream> getMappingStream() throws IOException {
        String pathString = System.getProperty("unprotect.mappings");
        if (pathString != null) {
            for (String path : pathString.split(Pattern.quote(File.pathSeparator))) {
                ZipFile zip = new ZipFile(new File(path));
                ZipEntry entry = zip.getEntry("mappings/mappings.tiny");
                if (entry == null) continue;
                return CloseableContainer.of(zip.getInputStream(entry), zip);
            }
            return null;
        }
        return CloseableContainer.of(TargetCache.class.getResourceAsStream("/mappings/mappings.tiny"), new Closeable[0]);
    }

    @Nullable
    private Set<String> loadClasses(BufferedReader reader) throws IOException {
        String line;
        HashSet<String> classes = new HashSet<String>();
        String first = reader.readLine();
        if (!first.startsWith(TINY_2_0_PREFIX)) {
            Transformation.LOGGER.warn("Unknown mapping format, should be Tiny v2");
            return null;
        }
        List<String> namespaces = Arrays.asList((first = first.substring(TINY_2_0_PREFIX.length())).split("\t"));
        int namespaceIndex = namespaces.indexOf("named");
        if (namespaceIndex == -1) {
            Transformation.LOGGER.warn("Could not find namespace 'named' in mappings (available: {})", namespaces);
            return null;
        }
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith(CLASS_PREFIX)) continue;
            String[] names = (line = line.substring(CLASS_PREFIX.length())).split("\t");
            String name = names[namespaceIndex];
            if (name.isEmpty()) {
                name = names[0];
            }
            classes.add(name);
        }
        return classes;
    }

    boolean isMinecraftClass(Type type) {
        if (this.minecraftClasses != null) {
            return this.minecraftClasses.contains(type.getInternalName());
        }
        String internalName = type.getInternalName();
        return internalName.startsWith("net/minecraft/") || internalName.startsWith("com/mojang/");
    }
}

