/*
 * Decompiled with CFR 0.152.
 */
package juuxel.unprotect;

import java.util.HashMap;
import java.util.Map;
import juuxel.unprotect.TargetCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

final class Transformation {
    private static final int ACCESS_MASK = 7;
    static final String TARGET_SYSTEM_PROPERTY = "unprotect.target";
    static final String MAPPING_LOCATION_SYSTEM_PROPERTY = "unprotect.mappings";
    static final Logger LOGGER = LogManager.getLogger((String)"unprotect");
    @Nullable
    private Target target;
    @Nullable
    private TargetCache targetCache;

    Transformation() {
    }

    private Target getTarget() {
        if (this.target == null) {
            String targetId = System.getProperty(TARGET_SYSTEM_PROPERTY, Target.MINECRAFT_AND_FORGE.id);
            this.target = (Target)((Object)Target.BY_ID.get(targetId));
            if (this.target == null) {
                LOGGER.error("Unknown Unprotect target: {} (available: {}), falling back to minecraft+forge", (Object)targetId, Target.BY_ID.keySet());
                this.target = Target.MINECRAFT_AND_FORGE;
            }
        }
        return this.target;
    }

    boolean handlesClass(Type classType, boolean isEmpty) {
        if (isEmpty) {
            return false;
        }
        switch (this.getTarget()) {
            case ALL: {
                return true;
            }
            case MINECRAFT_AND_FORGE: {
                if (classType.getInternalName().startsWith("net/minecraftforge/")) {
                    return true;
                }
                if (this.targetCache == null) {
                    this.targetCache = new TargetCache();
                }
                return this.targetCache.isMinecraftClass(classType);
            }
        }
        return false;
    }

    boolean processClass(ClassNode classNode) {
        int original = classNode.access;
        classNode.access = Transformation.changeAccess(classNode.access);
        boolean changed = original != classNode.access;
        for (InnerClassNode innerClass : classNode.innerClasses) {
            original = innerClass.access;
            innerClass.access = Transformation.changeAccess(innerClass.access);
            changed |= original != innerClass.access;
        }
        for (FieldNode field : classNode.fields) {
            original = field.access;
            field.access = Transformation.changeAccess(field.access);
            changed |= original != field.access;
        }
        for (MethodNode method : classNode.methods) {
            original = method.access;
            method.access = Transformation.changeAccess(method.access);
            changed |= original != method.access;
        }
        return changed;
    }

    @VisibleForTesting
    static int changeAccess(int access) {
        if ((access & 2) != 0) {
            return access;
        }
        return access & 0xFFFFFFF8 | 1;
    }

    private static enum Target {
        ALL("all"),
        MINECRAFT_AND_FORGE("minecraft+forge"),
        NONE("none");

        private static final Map<String, Target> BY_ID;
        private final String id;

        private Target(String id) {
            this.id = id;
        }

        static {
            BY_ID = new HashMap<String, Target>();
            for (Target target : Target.values()) {
                BY_ID.put(target.id, target);
            }
        }
    }
}

