/*
 * Decompiled with CFR 0.152.
 */
package juuxel.unprotect;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import juuxel.unprotect.Transformation;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public final class UnprotectAgent {
    public static void premain(String agentArgs, Instrumentation instrumentation) {
        instrumentation.addTransformer(new UnprotectTransformer(), instrumentation.isRetransformClassesSupported());
    }

    private static final class UnprotectTransformer
    implements ClassFileTransformer {
        private final Transformation transformation = new Transformation();

        private UnprotectTransformer() {
        }

        @Override
        public byte @Nullable [] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (!this.transformation.handlesClass(Type.getObjectType((String)className), false)) {
                return null;
            }
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            if (this.transformation.processClass(node)) {
                ClassWriter writer = new ClassWriter(reader, 0);
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
            return null;
        }
    }
}

