/*
 * Decompiled with CFR 0.152.
 */
package testcontainers.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.Callable;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import org.testcontainers.utility.DockerImageName;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public final class Nebula$ {
    public static final Nebula$ MODULE$ = new Nebula$();
    private static Option<Container> TestcontainersRyukContainer;
    private static String SessionId;
    private static final Duration StartTimeout;
    private static final Duration PollInterval;
    private static final Duration ContainerAtMost;
    private static final Duration NebulaPortAtMost;
    private static final DockerImageName DefaultGraphdImageName;
    private static final DockerImageName DefaultMetadImageName;
    private static final DockerImageName DefaultStoragedImageName;
    private static final DockerImageName DefaultConsoleImageName;
    private static final DockerClient dockerClient;
    private static volatile byte bitmap$0;

    static {
        StartTimeout = Duration.ofSeconds(30L);
        PollInterval = Duration.ofMillis(50L);
        ContainerAtMost = Duration.ofSeconds(10L);
        NebulaPortAtMost = Duration.ofSeconds(5L);
        DefaultGraphdImageName = DockerImageName.parse((String)"vesoft/nebula-graphd");
        DefaultMetadImageName = DockerImageName.parse((String)"vesoft/nebula-metad");
        DefaultStoragedImageName = DockerImageName.parse((String)"vesoft/nebula-storaged");
        DefaultConsoleImageName = DockerImageName.parse((String)"vesoft/nebula-console");
        dockerClient = DockerClientFactory.lazyClient();
    }

    public final String DefaultTag() {
        return "v3.6.0";
    }

    public final String Username() {
        return "root";
    }

    public final String Password() {
        return "nebula";
    }

    public final Duration StartTimeout() {
        return StartTimeout;
    }

    public final int WaitHostRetryTimes() {
        return 30;
    }

    public final int StopTimeout() {
        return 30;
    }

    public final int MinLogLevel() {
        return 0;
    }

    public final int LOGLevel() {
        return 0;
    }

    public final String TZ() {
        return "Asia/Shanghai";
    }

    public final String NetworkName() {
        return "testcontainers-nebula-network";
    }

    public final String NetworkType() {
        return "default";
    }

    public final Duration PollInterval() {
        return PollInterval;
    }

    public final Duration ContainerAtMost() {
        return ContainerAtMost;
    }

    public final Duration NebulaPortAtMost() {
        return NebulaPortAtMost;
    }

    public final String GraphdLogPath() {
        return "/logs/graph";
    }

    public final String MetadLogPath() {
        return "/logs/meta";
    }

    public final String StoragedLogPath() {
        return "/logs/storage";
    }

    public final String DataMetadPath() {
        return "/data/meta";
    }

    public final String DataStoragedPath() {
        return "/data/storage";
    }

    public final int GraphdExposedPort() {
        return 9669;
    }

    public final int MetadExposedPort() {
        return 9559;
    }

    public final int StoragedExposedPort() {
        return 9779;
    }

    public final DockerImageName DefaultGraphdImageName() {
        return DefaultGraphdImageName;
    }

    public final DockerImageName DefaultMetadImageName() {
        return DefaultMetadImageName;
    }

    public final DockerImageName DefaultStoragedImageName() {
        return DefaultStoragedImageName;
    }

    public final DockerImageName DefaultConsoleImageName() {
        return DefaultConsoleImageName;
    }

    public final String GraphdName() {
        return "graphd";
    }

    public final String MetadName() {
        return "metad";
    }

    public final String StoragedName() {
        return "storaged";
    }

    public final String ConsoleName() {
        return "console";
    }

    public final DockerClient dockerClient() {
        return dockerClient;
    }

    public final String Ryuk() {
        return "/testcontainers-ryuk";
    }

    private Option<Container> TestcontainersRyukContainer$lzycompute() {
        Nebula$ nebula$ = this;
        synchronized (nebula$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                List containersResponse = (List)Awaitility.await().atMost(this.ContainerAtMost()).pollInterval(this.PollInterval()).pollInSameThread().until((Callable)new Callable<List<Container>>(){

                    public List<Container> call() {
                        return CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)Nebula$.MODULE$.dockerClient().listContainersCmd().exec()).asScala().toList();
                    }
                }, cs -> cs.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)Nebula$.$anonfun$TestcontainersRyukContainer$2(c))).flatMap((Function1 & Serializable)x$2 -> ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])x$2.getNames())).toList()).headOption().nonEmpty());
                TestcontainersRyukContainer = containersResponse.headOption();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return TestcontainersRyukContainer;
    }

    public final Option<Container> TestcontainersRyukContainer() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.TestcontainersRyukContainer$lzycompute();
        }
        return TestcontainersRyukContainer;
    }

    private String SessionId$lzycompute() {
        Nebula$ nebula$ = this;
        synchronized (nebula$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                Option ryukName = ((LinearSeqOps)this.TestcontainersRyukContainer().map((Function1 & Serializable)x$3 -> ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])x$3.getNames())).toList()).toList().flatten(Predef$.MODULE$.$conforms())).headOption();
                SessionId = (String)ryukName.map((Function1 & Serializable)x$4 -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(x$4), "/testcontainers-ryuk-")).getOrElse((Function0 & Serializable)() -> DockerClientFactory.SESSION_ID);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return SessionId;
    }

    public final String SessionId() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.SessionId$lzycompute();
        }
        return SessionId;
    }

    public void removeTestcontainersNetwork(String networkId) {
        this.dockerClient().removeNetworkCmd(networkId).exec();
    }

    public static final /* synthetic */ boolean $anonfun$TestcontainersRyukContainer$2(Container c) {
        return Predef$.MODULE$.wrapRefArray((Object[])c.getNames()).toList().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("/testcontainers-ryuk")));
    }

    private Nebula$() {
    }
}

