/*
 * Decompiled with CFR 0.152.
 */
package testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Network;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.shaded.com.google.common.base.Throwables;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import testcontainers.containers.Nebula$;
import testcontainers.containers.NebulaClusterContainer$;
import testcontainers.containers.NebulaConsoleContainer;
import testcontainers.containers.NebulaGraphdContainer;
import testcontainers.containers.NebulaGraphdContainer$;
import testcontainers.containers.NebulaMetadContainer;
import testcontainers.containers.NebulaMetadContainer$;
import testcontainers.containers.NebulaStoragedContainer;
import testcontainers.containers.NebulaStoragedContainer$;
import testcontainers.containers.NebulaVolume;

@ScalaSignature(bytes="\u0006\u0005\t}v!B\u001f?\u0011\u0003\u0019e!B#?\u0011\u00031\u0005\"B'\u0002\t\u0003q\u0005\"B(\u0002\t#\u0001\u0006\"B7\u0002\t#q\u0007\"B:\u0002\t#!\b\"B<\u0002\t\u0013A\bbBA\u0001\u0003\u0011%\u00111\u0001\u0005\n\u0003\u001f\t!\u0019!C\u0005\u0003#A\u0001\"a\t\u0002A\u0003%\u00111\u0003\u0004\u0007\u000bz\n\t!!\n\t\u0011uT!\u0011!Q\u0001\n)D\u0011\"!\u0012\u000b\u0005\u0003\u0005\u000b\u0011B)\t\u0015\u0005\u001d#B!A!\u0002\u0013\tI\u0005\u0003\u0005w\u0015\t\u0005\t\u0015!\u0003R\u0011\u0019i%\u0002\"\u0001\u0002P!I\u00111\f\u0006C\u0002\u0013%\u0011Q\f\u0005\t\u0003SR\u0001\u0015!\u0003\u0002`!I\u00111\u000e\u0006C\u0002\u0013%\u0011Q\u000e\u0005\b\u0003_R\u0001\u0015!\u0003_\u0011%\t\tH\u0003b\u0001\n\u0013\ti\u0007C\u0004\u0002t)\u0001\u000b\u0011\u00020\t\u0013\u0005U$B1A\u0005\n\u00055\u0004bBA<\u0015\u0001\u0006IA\u0018\u0005\u000b\u0003sR\u0001R1A\u0005\u0012\u0005m\u0004BCA?\u0015!\u0015\r\u0011\"\u0003\u0002|!Q\u0011q\u0010\u0006\t\u0006\u0004%I!!!\t\u0015\u0005\r&\u0002#b\u0001\n\u0013\t)\u000b\u0003\u0006\u00024*A)\u0019!C\u0005\u0003kC!\"a1\u000b\u0011\u000b\u0007I\u0011BAc\u0011\u001d\tiM\u0003C\u0001\u0003\u001fDq!a6\u000b\t\u0013\tI\u000eC\u0004\u0002p*!)%!=\t\u000f\u0005e(\u0002\"\u0004\u0002r\"9\u00111 \u0006\u0005F\u0005E\bbBA\u007f\u0015\u0011\u0015\u0011q \u0005\b\u0005\u001bQAQ\u0001B\b\u0011\u001d\u0011\u0019B\u0003C\u0003\u0005\u001fAqA!\u0006\u000b\t\u000b\u0011y\u0001C\u0004\u0003\u0018)!)A!\u0007\t\u000f\tu!\u0002\"\u0002\u0003\u001a!9!q\u0004\u0006\u0005\u0006\te\u0001b\u0002B\u0011\u0015\u0011\u0015!q\u0002\u0005\b\u0005GQAQ\u0001B\b\u0011\u001d\u0011)C\u0003C\u0003\u0005\u001fAqAa\n\u000b\t\u000b\u0011I\u0003C\u0004\u00038)!)A!\u000f\t\u000f\t\u001d#\u0002\"\u0002\u0003J!9!q\u000b\u0006\u0005\u0006\te\u0003b\u0002B6\u0015\u0011\u0015!\u0011\f\u0005\b\u0005[RAQ\u0001B-\u0011\u001d\u0011yG\u0003C\u0003\u0005cBqAa \u000b\t\u000b\u0011\t\tC\u0004\u0003\u0010*!)A!%\t\u000f\t}%\u0002\"\u0002\u0003\"\"9!Q\u0015\u0006\u0005\u0006\t\u0005\u0006b\u0002BT\u0015\u0011\u0015!\u0011\u0015\u0005\b\u0005SSAQ\u0001BV\u0011\u001d\u0011IL\u0003C\u0003\u0005CCqAa/\u000b\t\u000b\u0011\t\u000bC\u0004\u0003>*!)A!)\u0002-9+'-\u001e7b\u00072,8\u000f^3s\u0007>tG/Y5oKJT!a\u0010!\u0002\u0015\r|g\u000e^1j]\u0016\u00148OC\u0001B\u00039!Xm\u001d;d_:$\u0018-\u001b8feN\u001c\u0001\u0001\u0005\u0002E\u00035\taH\u0001\fOK\n,H.Y\"mkN$XM]\"p]R\f\u0017N\\3s'\t\tq\t\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u000bqbZ3oKJ\fG/Z%q\u0003\u0012$'o\u001d\u000b\u0003#r\u0003\"AU-\u000f\u0005M;\u0006C\u0001+J\u001b\u0005)&B\u0001,C\u0003\u0019a$o\\8u}%\u0011\u0001,S\u0001\u0007!J,G-\u001a4\n\u0005i[&AB*ue&twM\u0003\u0002Y\u0013\")Ql\u0001a\u0001=\u0006i\u0011\u000e\u001d)peRl\u0015\r\u001d9j]\u001e\u00042a\u00183h\u001d\t\u0001'M\u0004\u0002UC&\t!*\u0003\u0002d\u0013\u00069\u0001/Y2lC\u001e,\u0017BA3g\u0005\u0011a\u0015n\u001d;\u000b\u0005\rL\u0005\u0003\u0002%i#*L!![%\u0003\rQ+\b\u000f\\33!\tA5.\u0003\u0002m\u0013\n\u0019\u0011J\u001c;\u0002\u001d%t7M]3bg\u0016d\u0015m\u001d;JaR\u0019\u0011k\\9\t\u000bA$\u0001\u0019A)\u0002\u0005%\u0004\b\"\u0002:\u0005\u0001\u0004Q\u0017a\u00018v[\u0006Iq-\u0019;fo\u0006L\u0018\n\u001d\u000b\u0003#VDQA^\u0003A\u0002E\u000b\u0001b];c]\u0016$\u0018\n]\u0001\u0013O\u0016$8\t\\;ti\u0016\u0014\bk\u001c:u\u0019&\u001cH\u000fF\u0002zyz\u00042a\u0018>k\u0013\tYhMA\u0002TKFDQ! \u0004A\u0002)\fqa\u00197vgR,'\u000fC\u0003\u0000\r\u0001\u0007!.\u0001\u0003q_J$\u0018\u0001E4fi\u000ecWo\u001d;fe&\u0003H*[:u)!\t)!a\u0002\u0002\n\u0005-\u0001cA0{#\")Qp\u0002a\u0001U\")ao\u0002a\u0001#\"1\u0011QB\u0004A\u0002)\faa\u001c4gg\u0016$\u0018A\u00027pO\u001e,'/\u0006\u0002\u0002\u0014A!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011!B:mMRR'BAA\u000f\u0003\ry'oZ\u0005\u0005\u0003C\t9B\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!'\u0015Q\u0011qEA\u001c!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\tA\u0001\\1oO*\u0011\u0011\u0011G\u0001\u0005U\u00064\u0018-\u0003\u0003\u00026\u0005-\"AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002:\u0005\u0005SBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u00131Lg-Z2zG2,'bA!\u0002\u001c%!\u00111IA\u001e\u0005%\u0019F/\u0019:uC\ndW-A\u0004wKJ\u001c\u0018n\u001c8\u0002-\u0005\u00147o\u001c7vi\u0016Dun\u001d;QCRD\u0007K]3gSb\u0004B\u0001SA&#&\u0019\u0011QJ%\u0003\r=\u0003H/[8o))\t\t&a\u0015\u0002V\u0005]\u0013\u0011\f\t\u0003\t*AQ!`\bA\u0002)Da!!\u0012\u0010\u0001\u0004\t\u0006bBA$\u001f\u0001\u0007\u0011\u0011\n\u0005\u0006m>\u0001\r!U\u0001\n]\u0016\u0014W\u000f\\1OKR,\"!a\u0018\u0011\t\u0005\u0005\u0014QM\u0007\u0003\u0003GR1aPA \u0013\u0011\t9'a\u0019\u0003\u000f9+Go^8sW\u0006Qa.\u001a2vY\u0006tU\r\u001e\u0011\u0002#5,G/Y%q!>\u0014H/T1qa&tw-F\u0001_\u0003IiW\r^1JaB{'\u000f^'baBLgn\u001a\u0011\u0002!M$xN]1hK&\u0003X*\u00199qS:<\u0017!E:u_J\fw-Z%q\u001b\u0006\u0004\b/\u001b8hA\u0005qqM]1qQ&\u0003X*\u00199qS:<\u0017aD4sCBD\u0017\n]'baBLgn\u001a\u0011\u0002\u00135,G/Y!eIJ\u001cX#A)\u0002\u001fILXo[\"p]R\f\u0017N\\3s\u0013\u0012\fa!\\3uC\u0012\u001cXCAAB!\u0011yF-!\"1\t\u0005\u001d\u0015\u0011\u0013\t\u0007\u0003C\nI)!$\n\t\u0005-\u00151\r\u0002\u0011\u000f\u0016tWM]5d\u0007>tG/Y5oKJ\u0004B!a$\u0002\u00122\u0001AaCAJ5\u0005\u0005\t\u0011!B\u0001\u0003+\u00131a\u0018\u00132#\u0011\t9*!(\u0011\u0007!\u000bI*C\u0002\u0002\u001c&\u0013qAT8uQ&tw\rE\u0002I\u0003?K1!!)J\u0005\r\te._\u0001\ngR|'/Y4fIN,\"!a*\u0011\t}#\u0017\u0011\u0016\u0019\u0005\u0003W\u000by\u000b\u0005\u0004\u0002b\u0005%\u0015Q\u0016\t\u0005\u0003\u001f\u000by\u000bB\u0006\u00022n\t\t\u0011!A\u0003\u0002\u0005U%aA0%e\u00059qM]1qQ\u0012\u001cXCAA\\!\u0011yF-!/1\t\u0005m\u0016q\u0018\t\u0007\u0003C\nI)!0\u0011\t\u0005=\u0015q\u0018\u0003\f\u0003\u0003d\u0012\u0011!A\u0001\u0006\u0003\t)JA\u0002`IM\nqaY8og>dW-\u0006\u0002\u0002HB\u0019A)!3\n\u0007\u0005-gH\u0001\fOK\n,H.Y\"p]N|G.Z\"p]R\f\u0017N\\3s\u0003Y)\u00070[:ugJ+hN\\5oO\u000e{g\u000e^1j]\u0016\u0014XCAAi!\rA\u00151[\u0005\u0004\u0003+L%a\u0002\"p_2,\u0017M\\\u0001\u0010C^\f\u0017\u000e^'baB,G\rU8siV!\u00111\\As)\u0015Q\u0017Q\\Av\u0011\u001d\tyn\ba\u0001\u0003C\f\u0011bY8oi\u0006Lg.\u001a:\u0011\r\u0005\u0005\u0014\u0011RAr!\u0011\ty)!:\u0005\u000f\u0005\u001dxD1\u0001\u0002j\n\t1+\u0005\u0003\u0002\u0018\u0006\u0005\bBBAw?\u0001\u0007!.A\u0006fqB|7/\u001a3Q_J$\u0018!B:uCJ$HCAAz!\rA\u0015Q_\u0005\u0004\u0003oL%\u0001B+oSR\f\u0011d\u001d;pa&3W\t_5tiN\u0014\u00160^6D_:$\u0018-\u001b8fe\u0006!1\u000f^8q\u00035\tG\u000e\\\"p]R\f\u0017N\\3sgV\u0011!\u0011\u0001\t\u0005?\u0012\u0014\u0019\u0001\r\u0003\u0003\u0006\t%\u0001CBA1\u0003\u0013\u00139\u0001\u0005\u0003\u0002\u0010\n%Aa\u0003B\u0006G\u0005\u0005\t\u0011!B\u0001\u0003+\u00131a\u0018\u00135\u000359'/\u00199iIV\u0013H\u000eT5tiV\u0011!\u0011\u0003\t\u0004?\u0012\f\u0016\u0001D7fi\u0006$WK\u001d7MSN$\u0018aD:u_J\fw-\u001a3Ve2d\u0015n\u001d;\u0002\u001d\u001d\u0014\u0018\r\u001d5e!>\u0014H\u000fT5tiV\u0011!1\u0004\t\u0004?\u0012T\u0017!D7fi\u0006$\u0007k\u001c:u\u0019&\u001cH/\u0001\tti>\u0014\u0018mZ3e!>\u0014H\u000fT5ti\u0006qqM]1qQ\u0012Dun\u001d;MSN$\u0018!D7fi\u0006$\u0007j\\:u\u0019&\u001cH/\u0001\tti>\u0014\u0018mZ3e\u0011>\u001cH\u000fT5ti\u0006IQ.\u001a;bI2K7\u000f^\u000b\u0003\u0005W\u0001Ba\u00183\u0003.A\"!q\u0006B\u001a!\u0019\t\t'!#\u00032A!\u0011q\u0012B\u001a\t-\u0011)$LA\u0001\u0002\u0003\u0015\t!!&\u0003\u0007}#S'\u0001\u0007ti>\u0014\u0018mZ3e\u0019&\u001cH/\u0006\u0002\u0003<A!q\f\u001aB\u001fa\u0011\u0011yDa\u0011\u0011\r\u0005\u0005\u0014\u0011\u0012B!!\u0011\tyIa\u0011\u0005\u0017\t\u0015c&!A\u0001\u0002\u000b\u0005\u0011Q\u0013\u0002\u0004?\u00122\u0014AC4sCBDG\rT5tiV\u0011!1\n\t\u0005?\u0012\u0014i\u0005\r\u0003\u0003P\tM\u0003CBA1\u0003\u0013\u0013\t\u0006\u0005\u0003\u0002\u0010\nMCa\u0003B+_\u0005\u0005\t\u0011!B\u0001\u0003+\u00131a\u0018\u00138\u0003E9W\r^$sCBDG\rU8si2K7\u000f^\u000b\u0003\u00057\u0002bA!\u0018\u0003d\t\u0015TB\u0001B0\u0015\u0011\u0011\t'a\f\u0002\tU$\u0018\u000e\\\u0005\u0004K\n}\u0003\u0003BA\u0015\u0005OJAA!\u001b\u0002,\t9\u0011J\u001c;fO\u0016\u0014\u0018\u0001E4fi6+G/\u00193Q_J$H*[:u\u0003M9W\r^*u_J\fw-\u001a3Q_J$H*[:u\u000319W\r^'fi\u0006$G*[:u+\t\u0011\u0019\b\u0005\u0004\u0003^\t\r$Q\u000f\u0019\u0005\u0005o\u0012Y\b\u0005\u0004\u0002b\u0005%%\u0011\u0010\t\u0005\u0003\u001f\u0013Y\bB\u0006\u0003~M\n\t\u0011!A\u0003\u0002\u0005U%aA0%q\u0005yq-\u001a;Ti>\u0014\u0018mZ3e\u0019&\u001cH/\u0006\u0002\u0003\u0004B1!Q\fB2\u0005\u000b\u0003DAa\"\u0003\fB1\u0011\u0011MAE\u0005\u0013\u0003B!a$\u0003\f\u0012Y!Q\u0012\u001b\u0002\u0002\u0003\u0005)\u0011AAK\u0005\ryF%O\u0001\u000eO\u0016$xI]1qQ\u0012d\u0015n\u001d;\u0016\u0005\tM\u0005C\u0002B/\u0005G\u0012)\n\r\u0003\u0003\u0018\nm\u0005CBA1\u0003\u0013\u0013I\n\u0005\u0003\u0002\u0010\nmEa\u0003BOk\u0005\u0005\t\u0011!B\u0001\u0003+\u0013Aa\u0018\u00132a\u0005\tr-\u001a;He\u0006\u0004\b\u000e\u001a%pgRd\u0015n\u001d;\u0016\u0005\t\r\u0006#\u0002B/\u0005G\n\u0016\u0001E4fi6+G/\u00193I_N$H*[:u\u0003M9W\r^*u_J\fw-\u001a3I_N$H*[:u\u0003A9W\r^!mY\u000e{g\u000e^1j]\u0016\u00148/\u0006\u0002\u0003.B1!Q\fB2\u0005_\u0003DA!-\u00036B1\u0011\u0011MAE\u0005g\u0003B!a$\u00036\u0012Y!qW\u001d\u0002\u0002\u0003\u0005)\u0011AAK\u0005\u0011yF%M\u0019\u0002!\u001d,Go\u0012:ba\"$WK\u001d7MSN$\u0018aD4fi6+G/\u00193Ve2d\u0015n\u001d;\u0002%\u001d,Go\u0015;pe\u0006<W\rZ+sY2K7\u000f\u001e")
public abstract class NebulaClusterContainer
implements Startable {
    private String metaAddrs;
    private String ryukContainerId;
    private List<GenericContainer<?>> metads;
    private List<GenericContainer<?>> storageds;
    private List<GenericContainer<?>> graphds;
    private NebulaConsoleContainer console;
    private final String version;
    private final Option<String> absoluteHostPathPrefix;
    private final String subnetIp;
    private final Network nebulaNet;
    private final List<Tuple2<String, Object>> metaIpPortMapping;
    private final List<Tuple2<String, Object>> storageIpMapping;
    private final List<Tuple2<String, Object>> graphIpMapping;
    private volatile byte bitmap$0;

    public Set<Startable> getDependencies() {
        return super.getDependencies();
    }

    public void close() {
        super.close();
    }

    private Network nebulaNet() {
        return this.nebulaNet;
    }

    private List<Tuple2<String, Object>> metaIpPortMapping() {
        return this.metaIpPortMapping;
    }

    private List<Tuple2<String, Object>> storageIpMapping() {
        return this.storageIpMapping;
    }

    private List<Tuple2<String, Object>> graphIpMapping() {
        return this.graphIpMapping;
    }

    private String metaAddrs$lzycompute() {
        NebulaClusterContainer nebulaClusterContainer = this;
        synchronized (nebulaClusterContainer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metaAddrs = NebulaClusterContainer$.MODULE$.generateIpAddrs(this.metaIpPortMapping());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metaAddrs;
    }

    public String metaAddrs() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.metaAddrs$lzycompute();
        }
        return this.metaAddrs;
    }

    private String ryukContainerId$lzycompute() {
        NebulaClusterContainer nebulaClusterContainer = this;
        synchronized (nebulaClusterContainer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Option<Container> containersResponse = Nebula$.MODULE$.TestcontainersRyukContainer();
                this.ryukContainerId = (String)containersResponse.map((Function1 & Serializable)x$1 -> x$1.getId()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.ryukContainerId;
    }

    private String ryukContainerId() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.ryukContainerId$lzycompute();
        }
        return this.ryukContainerId;
    }

    private List<GenericContainer<?>> metads$lzycompute() {
        NebulaClusterContainer nebulaClusterContainer = this;
        synchronized (nebulaClusterContainer) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.metads = ((List)this.metaIpPortMapping().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        if (tuple22 != null) {
                            String ip = (String)tuple22._1();
                            int port = tuple22._2$mcI$sp();
                            return new NebulaMetadContainer($this.version, ip, this.metaAddrs(), NebulaMetadContainer$.MODULE$.defaultPortBindings(port), (List<NebulaVolume>)((List)$this.absoluteHostPathPrefix.fold((Function0 & Serializable)() -> package$.MODULE$.List().empty(), (Function1 & Serializable)p -> NebulaMetadContainer$.MODULE$.defaultVolumeBindings((String)p, i))), i);
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }).map((Function1 & Serializable)x$2 -> (NebulaMetadContainer)x$2.withNetwork(this.nebulaNet()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.metads;
    }

    private List<GenericContainer<?>> metads() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.metads$lzycompute();
        }
        return this.metads;
    }

    private List<GenericContainer<?>> storageds$lzycompute() {
        NebulaClusterContainer nebulaClusterContainer = this;
        synchronized (nebulaClusterContainer) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.storageds = ((List)this.storageIpMapping().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        if (tuple22 != null) {
                            String ip = (String)tuple22._1();
                            int port = tuple22._2$mcI$sp();
                            return new NebulaStoragedContainer($this.version, ip, this.metaAddrs(), NebulaStoragedContainer$.MODULE$.defaultPortBindings(port), (List<NebulaVolume>)((List)$this.absoluteHostPathPrefix.fold((Function0 & Serializable)() -> package$.MODULE$.List().empty(), (Function1 & Serializable)p -> NebulaStoragedContainer$.MODULE$.defaultVolumeBindings((String)p, i))), i);
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }).map((Function1 & Serializable)x$3 -> (NebulaStoragedContainer)x$3.dependsOn((Startable[])this.metads().toArray(ClassTag$.MODULE$.apply(GenericContainer.class)))).map((Function1 & Serializable)x$4 -> (NebulaStoragedContainer)x$4.withNetwork(this.nebulaNet()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.storageds;
    }

    private List<GenericContainer<?>> storageds() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.storageds$lzycompute();
        }
        return this.storageds;
    }

    private List<GenericContainer<?>> graphds$lzycompute() {
        NebulaClusterContainer nebulaClusterContainer = this;
        synchronized (nebulaClusterContainer) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.graphds = ((List)this.graphIpMapping().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        if (tuple22 != null) {
                            String ip = (String)tuple22._1();
                            int port = tuple22._2$mcI$sp();
                            return new NebulaGraphdContainer($this.version, ip, this.metaAddrs(), NebulaGraphdContainer$.MODULE$.defaultPortBindings(port), (List<NebulaVolume>)((List)$this.absoluteHostPathPrefix.fold((Function0 & Serializable)() -> package$.MODULE$.List().empty(), (Function1 & Serializable)p -> NebulaGraphdContainer$.MODULE$.defaultVolumeBindings((String)p, i))), i);
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }).map((Function1 & Serializable)x$5 -> (NebulaGraphdContainer)x$5.dependsOn((Startable[])this.metads().toArray(ClassTag$.MODULE$.apply(GenericContainer.class)))).map((Function1 & Serializable)x$6 -> (NebulaGraphdContainer)x$6.withNetwork(this.nebulaNet()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.graphds;
    }

    private List<GenericContainer<?>> graphds() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.graphds$lzycompute();
        }
        return this.graphds;
    }

    private NebulaConsoleContainer console$lzycompute() {
        NebulaClusterContainer nebulaClusterContainer = this;
        synchronized (nebulaClusterContainer) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.console = (NebulaConsoleContainer)new NebulaConsoleContainer(this.version, (String)((Tuple2)this.graphIpMapping().head())._1(), ((Tuple2)this.graphIpMapping().head())._2$mcI$sp(), this.storageIpMapping()).withNetwork(this.nebulaNet());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.console;
    }

    private NebulaConsoleContainer console() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.console$lzycompute();
        }
        return this.console;
    }

    public boolean existsRunningContainer() {
        return this.metads().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isRunning())) || this.storageds().exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isRunning())) || this.graphds().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isRunning())) || this.console().isRunning();
    }

    private <S extends GenericContainer<S>> int awaitMappedPort(GenericContainer<S> container, int exposedPort) {
        String containerId = (String)Awaitility.await().atMost(Nebula$.MODULE$.NebulaPortAtMost()).pollInterval(Nebula$.MODULE$.PollInterval()).pollInSameThread().until((Callable)new Callable<String>(null, container){
            private final GenericContainer container$1;

            public String call() {
                return this.container$1.getContainerId();
            }
            {
                this.container$1 = container$1;
            }
        }, id -> id != null);
        if (containerId != null) {
            return container.getMappedPort(exposedPort);
        }
        throw new IllegalStateException("Mapped port can only be obtained after the container is started, awaitMappedPort failed!");
    }

    public final void start() {
        this.metads().foreach((Function1 & Serializable)md -> {
            NebulaClusterContainer.$anonfun$start$1(md);
            return BoxedUnit.UNIT;
        });
        this.storageds().foreach((Function1 & Serializable)sd -> {
            NebulaClusterContainer.$anonfun$start$3(sd);
            return BoxedUnit.UNIT;
        });
        this.graphds().foreach((Function1 & Serializable)gd -> {
            NebulaClusterContainer.$anonfun$start$5(gd);
            return BoxedUnit.UNIT;
        });
        this.console().start();
        Unreliables.retryUntilTrue((int)30, () -> {
            String g = this.console().execInContainer((String[])this.console().showHostsCommand().toArray(ClassTag$.MODULE$.apply(String.class))).getStdout();
            NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().debug(g);
            return Predef$.MODULE$.boolean2Boolean(g != null && g.contains("ONLINE") && !g.contains("OFFLINE"));
        });
    }

    private final void stopIfExistsRyukContainer() {
        boolean running = false;
        try {
            InspectContainerResponse containerInfo = Nebula$.MODULE$.dockerClient().inspectContainerCmd(this.ryukContainerId()).exec();
            running = containerInfo.getState() != null && BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)containerInfo.getState().getRunning());
        }
        catch (NotFoundException e) {
            NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().debug(new StringBuilder(64).append("Was going to stop container but it apparently no longer exists: ").append(this.ryukContainerId()).toString());
            return;
        }
        catch (Exception e) {
            NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().debug(new StringBuilder(133).append("Error encountered when checking container for shutdown (ID: ").append(this.ryukContainerId()).append(") - it may not have been stopped, or may already be stopped. Root cause: ").append(Throwables.getRootCause((Throwable)e).getMessage()).toString());
            return;
        }
        if (running) {
            try {
                NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().debug(new StringBuilder(20).append("Stopping container: ").append(this.ryukContainerId()).toString());
                Nebula$.MODULE$.dockerClient().killContainerCmd(this.ryukContainerId()).exec();
                NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().debug(new StringBuilder(19).append("Stopped container: ").append(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString("/testcontainers-ryuk"), "/")).toString());
            }
            catch (Exception e) {
                NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().debug(new StringBuilder(120).append("Error encountered shutting down container (ID: ").append(this.ryukContainerId()).append(") - it may not have been stopped, or may already be stopped. Root cause: ").append(Throwables.getRootCause((Throwable)e).getMessage()).toString());
            }
        }
        try {
            Nebula$.MODULE$.dockerClient().inspectContainerCmd(this.ryukContainerId()).exec();
        }
        catch (Exception e) {
            NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().debug(new StringBuilder(66).append("Was going to remove container but it apparently no longer exists: ").append(this.ryukContainerId()).toString());
            return;
        }
        try {
            NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().debug(new StringBuilder(20).append("Removing container: ").append(this.ryukContainerId()).toString());
            Nebula$.MODULE$.dockerClient().removeContainerCmd(this.ryukContainerId()).withRemoveVolumes(Predef$.MODULE$.boolean2Boolean(true)).withForce(Predef$.MODULE$.boolean2Boolean(true)).exec();
            NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().debug(new StringBuilder(44).append("Removed container and associated volume(s): ").append(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString("/testcontainers-ryuk"), "/")).toString());
        }
        catch (Exception e) {
            NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().debug(new StringBuilder(120).append("Error encountered shutting down container (ID: ").append(this.ryukContainerId()).append(") - it may not have been stopped, or may already be stopped. Root cause: ").append(Throwables.getRootCause((Throwable)e).getMessage()).toString());
        }
    }

    public final void stop() {
        try {
            Future res = Future$.MODULE$.sequence((IterableOnce)this.allContainers().map((Function1 & Serializable)f -> Future$.MODULE$.apply((Function0 & Serializable)() -> f, ExecutionContext.Implicits$.MODULE$.global())).map((Function1 & Serializable)x$10 -> x$10.map((Function1 & Serializable)x$11 -> {
                x$11.stop();
                return BoxedUnit.UNIT;
            }, ExecutionContext.Implicits$.MODULE$.global())), BuildFrom$.MODULE$.buildFromIterableOps(), ExecutionContext.Implicits$.MODULE$.global());
            Await$.MODULE$.result((Awaitable)res, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds());
            this.stopIfExistsRyukContainer();
            if (this.nebulaNet().getId() != null) {
                Nebula$.MODULE$.removeTestcontainersNetwork(this.nebulaNet().getId());
            }
        }
        catch (Throwable e) {
            NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().warn(new StringBuilder(31).append("Stopped all containers failed: ").append(e.getMessage()).toString());
        }
    }

    public final List<GenericContainer<?>> allContainers() {
        return (List)((IterableOps)((IterableOps)this.metads().$plus$plus(this.storageds())).$plus$plus(this.graphds())).$plus$plus((IterableOnce)new .colon.colon((Object)this.console(), (List)Nil$.MODULE$));
    }

    public final List<String> graphdUrlList() {
        return this.graphds().map((Function1 & Serializable)gd -> new StringBuilder(8).append("http://").append(gd.getHost()).append(":").append(this.awaitMappedPort((GenericContainer)gd, 9669)).toString());
    }

    public final List<String> metadUrlList() {
        return this.metads().map((Function1 & Serializable)md -> new StringBuilder(8).append("http://").append(md.getHost()).append(":").append(this.awaitMappedPort((GenericContainer)md, 9559)).toString());
    }

    public final List<String> storagedUrlList() {
        return this.storageds().map((Function1 & Serializable)sd -> new StringBuilder(8).append("http://").append(sd.getHost()).append(":").append(this.awaitMappedPort((GenericContainer)sd, 9779)).toString());
    }

    public final List<Object> graphdPortList() {
        return this.graphds().map((Function1 & Serializable)gd -> BoxesRunTime.boxToInteger((int)this.awaitMappedPort(gd, 9669)));
    }

    public final List<Object> metadPortList() {
        return this.metads().map((Function1 & Serializable)md -> BoxesRunTime.boxToInteger((int)this.awaitMappedPort(md, 9559)));
    }

    public final List<Object> storagedPortList() {
        return this.storageds().map((Function1 & Serializable)sd -> BoxesRunTime.boxToInteger((int)this.awaitMappedPort(sd, 9779)));
    }

    public final List<String> graphdHostList() {
        return this.graphds().map((Function1 & Serializable)x$12 -> x$12.getHost());
    }

    public final List<String> metadHostList() {
        return this.metads().map((Function1 & Serializable)x$13 -> x$13.getHost());
    }

    public final List<String> storagedHostList() {
        return this.storageds().map((Function1 & Serializable)x$14 -> x$14.getHost());
    }

    public final List<GenericContainer<?>> metadList() {
        return this.metads();
    }

    public final List<GenericContainer<?>> storagedList() {
        return this.storageds();
    }

    public final List<GenericContainer<?>> graphdList() {
        return this.graphds();
    }

    public final java.util.List<Integer> getGraphdPortList() {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.graphdPortList().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava();
    }

    public final java.util.List<Integer> getMetadPortList() {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.metadPortList().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava();
    }

    public final java.util.List<Integer> getStoragedPortList() {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.storagedPortList().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava();
    }

    public final java.util.List<GenericContainer<?>> getMetadList() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.metadList()).asJava();
    }

    public final java.util.List<GenericContainer<?>> getStoragedList() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.storagedList()).asJava();
    }

    public final java.util.List<GenericContainer<?>> getGraphdList() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.graphdList()).asJava();
    }

    public final java.util.List<String> getGraphdHostList() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.graphdHostList()).asJava();
    }

    public final java.util.List<String> getMetadHostList() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.metadHostList()).asJava();
    }

    public final java.util.List<String> getStoragedHostList() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.storagedHostList()).asJava();
    }

    public final java.util.List<GenericContainer<?>> getAllContainers() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.allContainers()).asJava();
    }

    public final java.util.List<String> getGraphdUrlList() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.graphdUrlList()).asJava();
    }

    public final java.util.List<String> getMetadUrlList() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.metadUrlList()).asJava();
    }

    public final java.util.List<String> getStoragedUrlList() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.storagedUrlList()).asJava();
    }

    public static final /* synthetic */ void $anonfun$start$1(GenericContainer md) {
        md.start();
        Unreliables.retryUntilTrue((int)((int)Nebula$.MODULE$.StartTimeout().getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> {
            String g = md.execInContainer(new String[]{"ps", "-ef"}).getStdout();
            return Predef$.MODULE$.boolean2Boolean(g != null && g.contains("metad"));
        });
    }

    public static final /* synthetic */ void $anonfun$start$3(GenericContainer sd) {
        sd.start();
        Unreliables.retryUntilTrue((int)((int)Nebula$.MODULE$.StartTimeout().getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> {
            String g = sd.execInContainer(new String[]{"ps", "-ef"}).getStdout();
            return Predef$.MODULE$.boolean2Boolean(g != null && g.contains("storaged"));
        });
    }

    public static final /* synthetic */ void $anonfun$start$5(GenericContainer gd) {
        gd.start();
        Unreliables.retryUntilTrue((int)((int)Nebula$.MODULE$.StartTimeout().getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> {
            String g = gd.execInContainer(new String[]{"ps", "-ef"}).getStdout();
            return Predef$.MODULE$.boolean2Boolean(g != null && g.contains("graphd"));
        });
    }

    public NebulaClusterContainer(int cluster, String version, Option<String> absoluteHostPathPrefix, String subnetIp) {
        this.version = version;
        this.absoluteHostPathPrefix = absoluteHostPathPrefix;
        this.subnetIp = subnetIp;
        this.nebulaNet = Network.builder().createNetworkCmdModifier(cmd -> cmd.withName("testcontainers-nebula-network").withIpam(new Network.Ipam().withDriver("default").withConfig(new Network.Ipam.Config[]{new Network.Ipam.Config().withSubnet($this.subnetIp).withGateway(NebulaClusterContainer$.MODULE$.gatewayIp($this.subnetIp))}))).build();
        this.metaIpPortMapping = ((IterableOnceOps)NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$getClusterIpList(cluster, subnetIp, 0).zip(NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$getClusterPortList(cluster, 9559))).toList();
        this.storageIpMapping = ((IterableOnceOps)NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$getClusterIpList(cluster, subnetIp, this.metaIpPortMapping().size()).zip(NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$getClusterPortList(cluster, 9779))).toList();
        this.graphIpMapping = ((IterableOnceOps)NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$getClusterIpList(cluster, subnetIp, this.storageIpMapping().size() + this.metaIpPortMapping().size()).zip(NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$getClusterPortList(cluster, 9669))).toList();
        NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().info(new StringBuilder(33).append("Nebula meta nodes started at ip: ").append(NebulaClusterContainer$.MODULE$.generateIpAddrs(this.metaIpPortMapping())).toString());
        NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().info(new StringBuilder(36).append("Nebula storage nodes started at ip: ").append(NebulaClusterContainer$.MODULE$.generateIpAddrs(this.storageIpMapping())).toString());
        NebulaClusterContainer$.MODULE$.testcontainers$containers$NebulaClusterContainer$$logger().info(new StringBuilder(34).append("Nebula graph nodes started at ip: ").append(NebulaClusterContainer$.MODULE$.generateIpAddrs(this.graphIpMapping())).toString());
    }
}

