/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.bundle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public class MultiResourceBundle
extends ResourceBundle {
    private final List<ResourceBundle> delegates;

    public MultiResourceBundle(List<ResourceBundle> resourceBundles) {
        this.delegates = resourceBundles == null ? new ArrayList() : resourceBundles;
    }

    @Override
    protected Object handleGetObject(String key) {
        Optional<Object> firstPropertyValue = this.delegates.stream().filter(delegate -> delegate.containsKey(key)).map(delegate -> delegate.getObject(key)).findFirst();
        return firstPropertyValue.orElse(null);
    }

    @Override
    public Enumeration<String> getKeys() {
        List keys = this.delegates.stream().filter(Objects::nonNull).flatMap(delegate -> Collections.list(delegate.getKeys()).stream()).collect(Collectors.toList());
        return Collections.enumeration(keys);
    }
}

