/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.functions;

import io.github.jy95.fds.common.config.FDSConfig;
import java.math.BigDecimal;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface QuantityToString<C extends FDSConfig, Q> {
    public static final String DURATION_SYSTEM = "http://hl7.org/fhir/ValueSet/duration-units";
    public static final String UNITS_OF_TIME_SYSTEM = "http://hl7.org/fhir/ValueSet/units-of-time";
    public static final List<String> TIME_SYSTEMS = List.of("http://hl7.org/fhir/ValueSet/duration-units", "http://hl7.org/fhir/ValueSet/units-of-time");

    default public CompletableFuture<String> convert(ResourceBundle bundle, C config, Q quantity) {
        CompletableFuture<String> comparator = this.comparatorToString(bundle, config, quantity);
        CompletableFuture<String> unit = this.hasUnit(quantity) ? this.enhancedFromUnitToString(config, quantity) : CompletableFuture.completedFuture("");
        String amount = this.getValue(quantity).toString();
        return comparator.thenCombineAsync(unit, (comparatorText, unitText) -> Stream.of(comparatorText, amount, unitText).filter(part -> !part.isEmpty()).collect(Collectors.joining(" ")));
    }

    public boolean hasUnit(Q var1);

    public BigDecimal getValue(Q var1);

    public CompletableFuture<String> enhancedFromUnitToString(C var1, Q var2);

    public CompletableFuture<String> comparatorToString(ResourceBundle var1, C var2, Q var3);
}

