/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.functions;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.config.FDSConfig;
import java.math.BigDecimal;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;

public interface RangeToString<C extends FDSConfig, R> {
    default public CompletableFuture<String> convert(ResourceBundle bundle, C config, R range) {
        if (this.hasUnit(range)) {
            return this.convertWithUnit(bundle, config, range);
        }
        return this.convertWithoutUnit(bundle, config, range);
    }

    public boolean hasUnit(R var1);

    default public CompletableFuture<String> convertWithoutUnit(ResourceBundle bundle, C config, R range) {
        return CompletableFuture.supplyAsync(() -> {
            boolean hasLow = this.hasLow(range);
            boolean hasHigh = this.hasHigh(range);
            String msg = bundle.getString("amount.range.withoutUnit");
            MessageFormat messageFormat = new MessageFormat(msg, config.getLocale());
            String condition = hasLow && hasHigh ? "0" : (hasHigh ? "1" : (hasLow ? "2" : "other"));
            Map<String, String> arguments = Map.of("minValue", hasLow ? this.getLowValue(range) : "", "maxValue", hasHigh ? this.getHighValue(range) : "", "condition", condition);
            return messageFormat.format(arguments);
        });
    }

    default public CompletableFuture<String> convertWithUnit(ResourceBundle bundle, C config, R range) {
        boolean hasLow = this.hasLow(range);
        boolean hasHigh = this.hasHigh(range);
        String msg = bundle.getString("amount.range.withUnit");
        CompletableFuture<String> unitRetrieval = this.getUnitText(bundle, config, range, hasLow, hasHigh);
        String condition = hasLow && hasHigh ? "0" : (hasHigh ? "1" : (hasLow ? "2" : "other"));
        return unitRetrieval.thenApplyAsync(unitAsText -> {
            Map<String, String> arguments = Map.of("minValue", hasLow ? this.getLowValue(range) : "", "maxValue", hasHigh ? this.getHighValue(range) : "", "condition", condition, "unit", unitAsText);
            MessageFormat messageFormat = new MessageFormat(msg, config.getLocale());
            return messageFormat.format(arguments);
        });
    }

    public CompletableFuture<String> getUnitText(ResourceBundle var1, C var2, R var3, boolean var4, boolean var5);

    public boolean hasLow(R var1);

    public boolean hasHigh(R var1);

    public BigDecimal getLowValue(R var1);

    public BigDecimal getHighValue(R var1);
}

