/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.functions;

import io.github.jy95.fds.common.config.FDSConfig;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface RatioToString<C extends FDSConfig, R> {
    default public CompletableFuture<String> convert(ResourceBundle bundle, C config, R ratio) {
        String linkword = this.retrieveRatioLinkWord(bundle, config, ratio);
        CompletableFuture<String> numeratorText = this.hasNumerator(ratio) ? this.convertNumerator(bundle, config, ratio) : CompletableFuture.completedFuture("");
        CompletableFuture<String> denominatorText = this.hasDenominator(ratio) ? this.convertDenominator(bundle, config, ratio) : CompletableFuture.completedFuture("");
        return numeratorText.thenCombineAsync(denominatorText, (num, dem) -> Stream.of(num, linkword, dem).filter(s -> !s.isEmpty()).collect(Collectors.joining(" ")));
    }

    public String retrieveRatioLinkWord(ResourceBundle var1, C var2, R var3);

    public boolean hasNumerator(R var1);

    public CompletableFuture<String> convertNumerator(ResourceBundle var1, C var2, R var3);

    public boolean hasDenominator(R var1);

    public CompletableFuture<String> convertDenominator(ResourceBundle var1, C var2, R var3);
}

