/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SequenceUtils {
    private SequenceUtils() {
    }

    public static <T> boolean containsOnlySequentialInstructions(List<T> dosages, Function<T, Integer> getSequence) {
        Set encounteredSequenceNumbers = dosages.stream().map(getSequence).filter(i -> i > 0).collect(Collectors.toSet());
        return encounteredSequenceNumbers.isEmpty() || encounteredSequenceNumbers.size() == dosages.size();
    }

    public static <T> List<List<T>> groupBySequence(List<T> dosages, Function<T, Integer> getSequence) {
        HashMap<Integer, List> sequencesMap = new HashMap<Integer, List>();
        for (T dosage : dosages) {
            Integer sequenceNr = getSequence.apply(dosage);
            sequencesMap.computeIfAbsent(sequenceNr, k -> new ArrayList()).add(dosage);
        }
        return new ArrayList<List<T>>(sequencesMap.values());
    }
}

