/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.functions;

import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.number.UnlocalizedNumberFormatter;
import com.ibm.icu.util.MeasureUnit;
import java.util.Locale;
import java.util.Map;

public final class UnitsOfTimeFormatter {
    private static final Map<String, MeasureUnit> UNIT_MAPPING = Map.ofEntries(Map.entry("ms", MeasureUnit.MILLISECOND), Map.entry("s", MeasureUnit.SECOND), Map.entry("min", MeasureUnit.MINUTE), Map.entry("h", MeasureUnit.HOUR), Map.entry("d", MeasureUnit.DAY), Map.entry("wk", MeasureUnit.WEEK), Map.entry("mo", MeasureUnit.MONTH), Map.entry("a", MeasureUnit.YEAR));
    private static final UnlocalizedNumberFormatter formatter = (UnlocalizedNumberFormatter)NumberFormatter.with().unitWidth(NumberFormatter.UnitWidth.FULL_NAME);

    private UnitsOfTimeFormatter() {
    }

    public static String formatWithCount(Locale locale, String unit, Number count) {
        return ((LocalizedNumberFormatter)formatter.locale(locale).unit(UNIT_MAPPING.get(unit))).format(count).toString();
    }

    public static String formatWithoutCount(Locale locale, String unit, Number count) {
        return ((LocalizedNumberFormatter)((UnlocalizedNumberFormatter)formatter.unit(UNIT_MAPPING.get(unit))).locale(locale).precision(Precision.maxSignificantDigits((int)1))).format(count).toString().substring(2);
    }
}

