/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.config.FDSConfig;
import io.github.jy95.fds.common.types.TranslatorTiming;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public interface BoundsPeriod<C extends FDSConfig, D>
extends TranslatorTiming<C, D> {
    default public MessageFormat getBoundsPeriodMsg(ResourceBundle bundle, Locale locale) {
        String msg = bundle.getString("fields.boundsPeriod");
        return new MessageFormat(msg, locale);
    }

    default public Map<String, Object> extractInformation(D dosage) {
        String endDate;
        boolean hasStart = this.hasStartPeriod(dosage);
        boolean hasEnd = this.hasEndPeriod(dosage);
        String startDate = hasStart ? this.formatStartPeriod(dosage) : "";
        String string = endDate = hasEnd ? this.formatEndPeriod(dosage) : "";
        String condition = hasStart && hasEnd ? "0" : (hasStart ? "1" : "other");
        return Map.of("startDate", startDate, "endDate", endDate, "condition", condition);
    }

    public boolean hasStartPeriod(D var1);

    public boolean hasEndPeriod(D var1);

    public String formatStartPeriod(D var1);

    public String formatEndPeriod(D var1);
}

