/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.config.FDSConfig;
import io.github.jy95.fds.common.types.TranslatorTiming;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;

public interface DurationDurationMax<C extends FDSConfig, D>
extends TranslatorTiming<C, D> {
    default public MessageFormat getDurationMsg(ResourceBundle bundle, Locale locale) {
        String msg = bundle.getString("fields.duration");
        return new MessageFormat(msg, locale);
    }

    default public MessageFormat getDurationMaxMsg(ResourceBundle bundle, Locale locale) {
        String msg = bundle.getString("fields.durationMax");
        return new MessageFormat(msg, locale);
    }

    @Override
    default public CompletableFuture<String> convert(D dosage) {
        return CompletableFuture.supplyAsync(() -> {
            boolean hasDurationFlag = this.hasDuration(dosage);
            boolean hasDurationMaxFlag = this.hasDurationMax(dosage);
            boolean hasBoth = hasDurationFlag && hasDurationMaxFlag;
            ArrayList<String> texts = new ArrayList<String>();
            if (hasDurationFlag) {
                texts.add(this.turnDurationToString(dosage));
            }
            if (hasBoth) {
                texts.add("(");
            }
            if (hasDurationMaxFlag) {
                texts.add(this.turnDurationMaxToString(dosage));
            }
            if (hasBoth) {
                texts.add(")");
            }
            return String.join((CharSequence)" ", texts);
        });
    }

    public boolean hasDuration(D var1);

    public boolean hasDurationMax(D var1);

    public String turnDurationToString(D var1);

    public String turnDurationMaxToString(D var1);
}

