/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.config.FDSConfig;
import io.github.jy95.fds.common.types.TranslatorTiming;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;

public interface FrequencyFrequencyMax<C extends FDSConfig, D>
extends TranslatorTiming<C, D> {
    default public MessageFormat getFrequencyAndFrequencyMaxMsg(ResourceBundle bundle, Locale locale) {
        String msg = bundle.getString("fields.frequencyAndFrequencyMax");
        return new MessageFormat(msg, locale);
    }

    default public MessageFormat getFrequencyMaxMsg(ResourceBundle bundle, Locale locale) {
        String msg = bundle.getString("fields.frequencyMax");
        return new MessageFormat(msg, locale);
    }

    default public MessageFormat getFrequencyMsg(ResourceBundle bundle, Locale locale) {
        String msg = bundle.getString("fields.frequency");
        return new MessageFormat(msg, locale);
    }

    @Override
    default public CompletableFuture<String> convert(D dosage) {
        return CompletableFuture.supplyAsync(() -> {
            boolean hasBoth;
            boolean hasFrequencyFlag = this.hasFrequency(dosage);
            boolean hasFrequencyMaxFlag = this.hasFrequencyMax(dosage);
            boolean bl = hasBoth = hasFrequencyFlag && hasFrequencyMaxFlag;
            if (hasBoth) {
                return this.turnFrequencyAndFrequencyMaxToString(dosage);
            }
            if (hasFrequencyMaxFlag) {
                return this.turnFrequencyMaxToString(dosage);
            }
            return this.turnFrequencyToString(dosage);
        });
    }

    public String formatFrequencyAndFrequencyMaxText(int var1, int var2);

    public String formatFrequencyMaxText(int var1);

    public String formatFrequencyText(int var1);

    public boolean hasFrequency(D var1);

    public boolean hasFrequencyMax(D var1);

    public String turnFrequencyAndFrequencyMaxToString(D var1);

    public String turnFrequencyMaxToString(D var1);

    public String turnFrequencyToString(D var1);
}

