/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.translators;

import io.github.jy95.fds.common.config.FDSConfig;
import io.github.jy95.fds.common.types.Translator;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface FrequencyFrequencyMaxPeriodPeriodMax<C extends FDSConfig, D>
extends Translator<C, D> {
    public boolean hasFrequency(D var1);

    public boolean hasPeriod(D var1);

    @Override
    default public boolean isPresent(D dosage) {
        return this.hasFrequency(dosage) || this.hasPeriod(dosage);
    }

    @Override
    default public CompletableFuture<String> convert(D dosage) {
        CompletableFuture<String> frequencyPart = this.extractFrequency(dosage);
        CompletableFuture<String> periodPart = this.extractPeriod(dosage);
        return frequencyPart.thenCombineAsync(periodPart, (freq, period) -> Stream.of(freq, period).filter(part -> !part.isEmpty()).collect(Collectors.joining(" ")));
    }

    public CompletableFuture<String> extractFrequency(D var1);

    public CompletableFuture<String> extractPeriod(D var1);
}

