/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.config.FDSConfig;
import io.github.jy95.fds.common.types.TranslatorTiming;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;

public interface PeriodPeriodMax<C extends FDSConfig, D>
extends TranslatorTiming<C, D> {
    default public MessageFormat getPeriodMaxMsg(ResourceBundle bundle, Locale locale) {
        String msg = bundle.getString("fields.periodMax");
        return new MessageFormat(msg, locale);
    }

    default public MessageFormat getPeriodMsg(ResourceBundle bundle, Locale locale) {
        String msg = bundle.getString("fields.period");
        return new MessageFormat(msg, locale);
    }

    @Override
    default public CompletableFuture<String> convert(D dosage) {
        return CompletableFuture.supplyAsync(() -> {
            boolean hasBoth;
            boolean hasPeriodFlag = this.hasPeriod(dosage);
            boolean hasPeriodMaxFlag = this.hasPeriodMax(dosage);
            boolean bl = hasBoth = hasPeriodFlag && hasPeriodMaxFlag;
            if (hasBoth) {
                return this.turnPeriodAndPeriodMaxToString(dosage);
            }
            return this.turnPeriodToString(dosage);
        });
    }

    public boolean hasPeriod(D var1);

    public boolean hasPeriodMax(D var1);

    public String turnPeriodAndPeriodMaxToString(D var1);

    public String turnPeriodToString(D var1);
}

