/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.types;

import io.github.jy95.fds.common.config.FDSConfig;
import io.github.jy95.fds.common.types.DisplayOrder;
import io.github.jy95.fds.common.types.Translator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public abstract class AbstractTranslatorsMap<C extends FDSConfig, D> {
    private final Map<DisplayOrder, Supplier<Translator<C, D>>> translatorSuppliers;
    private final Map<DisplayOrder, Translator<C, D>> translatorCache = new ConcurrentHashMap<DisplayOrder, Translator<C, D>>();

    public AbstractTranslatorsMap(Map<DisplayOrder, Supplier<Translator<C, D>>> translatorSuppliers) {
        this.translatorSuppliers = translatorSuppliers;
    }

    public Translator<C, D> getTranslator(DisplayOrder displayOrder) {
        return this.translatorCache.computeIfAbsent(displayOrder, key -> {
            Supplier<Translator<C, D>> supplier = this.translatorSuppliers.get(key);
            return supplier != null ? supplier.get() : null;
        });
    }
}

