/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.types;

import io.github.jy95.fds.common.config.FDSConfig;
import io.github.jy95.fds.common.functions.ListToString;
import io.github.jy95.fds.common.types.DisplayOrder;
import io.github.jy95.fds.common.types.LinkWord;
import io.github.jy95.fds.common.types.Translator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;

public abstract class DosageAPI<C extends FDSConfig, D> {
    private final C config;
    private final ResourceBundle resources;

    public DosageAPI(C config) {
        this.config = config;
        this.resources = ((FDSConfig)config).getSelectResourceBundle().apply(((FDSConfig)config).getLocale());
    }

    public CompletableFuture<String> getFields(D dosage, DisplayOrder ... fields) {
        String separator = ((FDSConfig)this.config).getDisplaySeparator();
        List translatorsFields = Arrays.stream(fields).map(this::getTranslator).filter(Objects::nonNull).filter(translator -> translator.isPresent(dosage)).map(translator -> translator.convert(dosage)).collect(Collectors.toList());
        return CompletableFuture.allOf((CompletableFuture[])translatorsFields.toArray(CompletableFuture[]::new)).thenApplyAsync(v -> translatorsFields.stream().map(s -> s.getNow("")).collect(Collectors.joining(separator)));
    }

    public abstract Translator<C, D> getTranslator(DisplayOrder var1);

    public abstract boolean containsOnlySequentialInstructions(List<D> var1);

    public CompletableFuture<String> asHumanReadableText(D dosage) {
        DisplayOrder[] fields = (DisplayOrder[])((FDSConfig)this.config).getDisplayOrder().toArray(DisplayOrder[]::new);
        return this.getFields(dosage, fields);
    }

    public CompletableFuture<String> asHumanReadableText(List<D> dosages) {
        if (this.containsOnlySequentialInstructions(dosages)) {
            return this.convertSequentialDosagesToText(dosages);
        }
        return this.convertGroupedDosagesToText(dosages);
    }

    protected CompletableFuture<String> convertSequentialDosagesToText(List<D> dosages) {
        List dosagesAsTextFutures = dosages.stream().map(this::asHumanReadableText).collect(Collectors.toList());
        return CompletableFuture.allOf((CompletableFuture[])dosagesAsTextFutures.toArray(CompletableFuture[]::new)).thenApplyAsync(v -> {
            List<String> dosagesAsText = this.extractCompletedFutures(dosagesAsTextFutures);
            return this.convertToText(dosagesAsText, LinkWord.THEN);
        });
    }

    protected CompletableFuture<String> convertGroupedDosagesToText(List<D> dosages) {
        List<List<D>> sortedDosages = this.groupBySequence(dosages);
        List sequentialInstructionsFutures = sortedDosages.stream().map(this::convertConcurrentDosagesToText).collect(Collectors.toList());
        return CompletableFuture.allOf((CompletableFuture[])sequentialInstructionsFutures.toArray(CompletableFuture[]::new)).thenApplyAsync(v -> {
            List<String> dosagesAsText = this.extractCompletedFutures(sequentialInstructionsFutures);
            return this.convertToText(dosagesAsText, LinkWord.THEN);
        });
    }

    protected CompletableFuture<String> convertConcurrentDosagesToText(List<D> dosages) {
        List concurrentInstructionsFutures = dosages.stream().map(this::asHumanReadableText).collect(Collectors.toList());
        return CompletableFuture.allOf((CompletableFuture[])concurrentInstructionsFutures.toArray(CompletableFuture[]::new)).thenApplyAsync(v -> {
            List<String> dosagesAsText = this.extractCompletedFutures(concurrentInstructionsFutures);
            return this.convertToText(dosagesAsText, LinkWord.AND);
        });
    }

    protected abstract List<List<D>> groupBySequence(List<D> var1);

    private List<String> extractCompletedFutures(List<CompletableFuture<String>> futures) {
        return futures.stream().map(future -> future.getNow("")).collect(Collectors.toList());
    }

    private String convertToText(List<String> textList, LinkWord linkWord) {
        ResourceBundle bundle = this.getResources();
        return ListToString.convert(bundle, textList, linkWord);
    }

    @Generated
    public C getConfig() {
        return this.config;
    }

    @Generated
    public ResourceBundle getResources() {
        return this.resources;
    }
}

