/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.common.types;

import io.github.jy95.fds.common.types.DosageAPI;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface DosageMarkdown<A extends DosageAPI<?, B>, B> {
    default public List<Locale> getLocales() {
        return List.of(Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN, Locale.forLanguageTag("nl-BE"));
    }

    default public Path getResourcesDir() {
        return Paths.get("src", "site", "resources", "examples");
    }

    default public Path getBaseOutputDir(Locale locale) {
        return Paths.get("src", "site", locale.toString(), "markdown", "examples");
    }

    public A createDosageAPI(Locale var1);

    default public Map<Locale, A> getDosageAPIs() {
        return this.getLocales().stream().collect(Collectors.toMap(locale -> locale, this::createDosageAPI));
    }

    public List<B> getDosageFromJson(Path var1) throws IOException;

    default public Stream<Path> getJsonFiles() throws IOException {
        return Files.walk(this.getResourcesDir(), new FileVisitOption[0]).filter(path -> path.toString().endsWith(".json"));
    }

    default public Map<Path, List<Path>> getJsonFilesGroupedByFolder() throws IOException {
        try (Stream<Path> jsonFilesStream = this.getJsonFiles();){
            Map<Path, List<Path>> map = jsonFilesStream.collect(Collectors.groupingBy(Path::getParent));
            return map;
        }
    }

    default public void generateMarkdown() throws Exception {
        Map<Locale, A> dosageAPIs = this.getDosageAPIs();
        Map<Path, List<Path>> groupedJsonFiles = this.getJsonFilesGroupedByFolder();
        for (Locale locale : this.getLocales()) {
            Path baseOutputDir = this.getBaseOutputDir(locale);
            Files.createDirectories(baseOutputDir, new FileAttribute[0]);
            DosageAPI dosageApiForLocale = (DosageAPI)dosageAPIs.get(locale);
            for (Map.Entry<Path, List<Path>> entry : groupedJsonFiles.entrySet()) {
                Path folder = entry.getKey();
                List<Path> jsonFilesInFolder = entry.getValue();
                Path markdownFile = baseOutputDir.resolve(this.getRelativeMarkdownFilePath(folder));
                Files.createDirectories(markdownFile.getParent(), new FileAttribute[0]);
                this.generateMarkdownForFolderAndLocale(dosageApiForLocale, folder, markdownFile, jsonFilesInFolder);
            }
        }
    }

    default public String getDosageJsonAsString(Path jsonFile) throws IOException {
        return Files.readString(jsonFile);
    }

    private void generateMarkdownForFolderAndLocale(A dosageApi, Path inputFolder, Path markdownFile, List<Path> jsonFilesToProcess) throws IOException, ExecutionException, InterruptedException {
        try (BufferedWriter writer = Files.newBufferedWriter(markdownFile, new OpenOption[0]);){
            String headerName = inputFolder.getFileName().toString();
            this.writeMarkdownHeader(writer, headerName);
            this.writeMarkdownTableStart(writer);
            jsonFilesToProcess.stream().forEach(jsonFile -> {
                try {
                    Map<String, String> data = this.extractJsonFile(dosageApi, (Path)jsonFile).get();
                    this.writeMarkdownTableRow(writer, data.get("json"), data.get("dosage"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.writeMarkdownTableEnd(writer);
        }
    }

    private String getRelativeMarkdownFilePath(Path folder) {
        Path resourcesDir = this.getResourcesDir();
        String fileName = folder.getFileName().toString() + ".md";
        Path relativePathFromResources = resourcesDir.relativize(folder);
        int nameCount = relativePathFromResources.getNameCount();
        if (nameCount <= 1) {
            return fileName;
        }
        return relativePathFromResources.subpath(0, nameCount - 1).resolve(fileName).toString();
    }

    private void writeMarkdownHeader(BufferedWriter writer, String folderName) throws IOException {
        writer.write("# " + folderName + " \n\n");
    }

    private void writeMarkdownTableStart(BufferedWriter writer) throws IOException {
        writer.write("<table>\n");
        writer.write("  <thead>\n");
        writer.write("    <tr>\n");
        writer.write("      <th>Dosage</th>\n");
        writer.write("      <th>Human readable text</th>\n");
        writer.write("    </tr>\n");
        writer.write("  </thead>\n");
        writer.write("  <tbody>\n");
    }

    private CompletableFuture<Map<String, String>> extractJsonFile(A dosageApi, Path jsonFile) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                List<B> dosages = this.getDosageFromJson(jsonFile);
                String outputText = dosageApi.asHumanReadableText(dosages).get();
                String jsonContent = this.escapeHtml(this.getDosageJsonAsString(jsonFile));
                return Map.of("dosage", outputText, "json", jsonContent);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void writeMarkdownTableRow(BufferedWriter writer, String jsonContent, String outputText) throws IOException {
        writer.write("    <tr>\n");
        writer.write("      <td><pre><code class=\"language-json\">" + jsonContent + "</code></pre></td>\n");
        writer.write("      <td>" + this.escapeHtml(outputText).replace("\n", "<br>") + "</td>\n");
        writer.write("    </tr>\n");
    }

    private void writeMarkdownTableEnd(BufferedWriter writer) throws IOException {
        writer.write("  </tbody>\n");
        writer.write("</table>\n");
    }

    default public String escapeHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#039;");
    }
}

