/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.config;

import io.github.jy95.fds.common.types.DoseAndRateExtractor;
import io.github.jy95.fds.common.types.DoseAndRateKey;
import io.github.jy95.fds.r4.functions.DoseAndRateRegistryR4;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Type;

public final class DefaultImplementationsR4 {
    private DefaultImplementationsR4() {
    }

    public static CompletableFuture<String> fromFHIRQuantityUnitToString(Quantity quantity) {
        return CompletableFuture.supplyAsync(() -> {
            if (Objects.isNull(quantity)) {
                return null;
            }
            if (Objects.nonNull(quantity.getCode())) {
                return quantity.getCode();
            }
            if (Objects.nonNull(quantity.getUnit())) {
                return quantity.getUnit();
            }
            return "";
        });
    }

    public static CompletableFuture<String> fromCodeableConceptToString(CodeableConcept codeableConcept) {
        return CompletableFuture.supplyAsync(() -> {
            if (Objects.isNull(codeableConcept)) {
                return null;
            }
            if (Objects.nonNull(codeableConcept.getText())) {
                return codeableConcept.getText();
            }
            if (!codeableConcept.hasCoding()) {
                return null;
            }
            Coding firstCode = codeableConcept.getCodingFirstRep();
            String display = firstCode.getDisplay();
            String code = firstCode.getCode();
            return Objects.nonNull(display) ? display : code;
        });
    }

    public static CompletableFuture<String> fromExtensionsToString(List<Extension> extensions) {
        return CompletableFuture.supplyAsync(() -> {
            if (extensions.isEmpty()) {
                return null;
            }
            return extensions.stream().map(ext -> {
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                if (ext.hasUrl()) {
                    sb.append("\"url\":\"").append(ext.getUrl()).append("\"");
                }
                if (ext.hasUrl() && ext.hasValue()) {
                    sb.append(",");
                }
                if (ext.hasValue()) {
                    sb.append("\"value[x]\":\"").append(ext.getValueAsPrimitive().getValueAsString()).append("\"");
                }
                sb.append("}");
                return sb.toString();
            }).collect(Collectors.joining(", ", "[", "]"));
        });
    }

    public static Type selectDosageAndRateField(List<Dosage.DosageDoseAndRateComponent> doseAndRateComponentList, DoseAndRateKey doseAndRateKey) {
        DoseAndRateExtractor<Dosage.DosageDoseAndRateComponent, Type> extractor = DoseAndRateRegistryR4.getInstance().getExtractor(doseAndRateKey);
        Dosage.DosageDoseAndRateComponent firstRep = doseAndRateComponentList.get(0);
        return (Type)extractor.extract((Object)firstRep);
    }

    public static boolean hasMatchingComponent(Dosage dosage, Predicate<Dosage.DosageDoseAndRateComponent> predicate) {
        return dosage.hasDoseAndRate() && dosage.getDoseAndRate().stream().anyMatch(predicate);
    }
}

