/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.config;

import io.github.jy95.fds.common.config.FDSConfig;
import io.github.jy95.fds.common.types.DoseAndRateKey;
import io.github.jy95.fds.common.types.FDSOperations;
import io.github.jy95.fds.r4.config.DefaultImplementationsR4;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Type;

public class FDSConfigR4
extends FDSConfig
implements FDSOperations<Quantity, CodeableConcept, Extension, Dosage, Dosage.DosageDoseAndRateComponent, Type> {
    private final Function<Quantity, CompletableFuture<String>> fromFHIRQuantityUnitToString;
    private final Function<CodeableConcept, CompletableFuture<String>> fromCodeableConceptToString;
    private final Function<List<Extension>, CompletableFuture<String>> fromExtensionsToString;
    private final BiFunction<List<Dosage.DosageDoseAndRateComponent>, DoseAndRateKey, Type> selectDosageAndRateField;
    private final BiFunction<Dosage, Predicate<Dosage.DosageDoseAndRateComponent>, Boolean> hasMatchingComponent;

    public CompletableFuture<String> fromFHIRQuantityUnitToString(Quantity quantity) {
        return this.fromFHIRQuantityUnitToString.apply(quantity);
    }

    public CompletableFuture<String> fromCodeableConceptToString(CodeableConcept codeableConcept) {
        return this.fromCodeableConceptToString.apply(codeableConcept);
    }

    public CompletableFuture<String> fromExtensionsToString(List<Extension> extensions) {
        return this.fromExtensionsToString.apply(extensions);
    }

    public Type selectDosageAndRateField(List<Dosage.DosageDoseAndRateComponent> doseAndRateComponentList, DoseAndRateKey doseAndRateKey) {
        return this.selectDosageAndRateField.apply(doseAndRateComponentList, doseAndRateKey);
    }

    public boolean hasMatchingComponent(Dosage dosage, Predicate<Dosage.DosageDoseAndRateComponent> predicate) {
        return this.hasMatchingComponent.apply(dosage, predicate);
    }

    @Generated
    private static Function<Quantity, CompletableFuture<String>> $default$fromFHIRQuantityUnitToString() {
        return DefaultImplementationsR4::fromFHIRQuantityUnitToString;
    }

    @Generated
    private static Function<CodeableConcept, CompletableFuture<String>> $default$fromCodeableConceptToString() {
        return DefaultImplementationsR4::fromCodeableConceptToString;
    }

    @Generated
    private static Function<List<Extension>, CompletableFuture<String>> $default$fromExtensionsToString() {
        return DefaultImplementationsR4::fromExtensionsToString;
    }

    @Generated
    private static BiFunction<List<Dosage.DosageDoseAndRateComponent>, DoseAndRateKey, Type> $default$selectDosageAndRateField() {
        return DefaultImplementationsR4::selectDosageAndRateField;
    }

    @Generated
    private static BiFunction<Dosage, Predicate<Dosage.DosageDoseAndRateComponent>, Boolean> $default$hasMatchingComponent() {
        return DefaultImplementationsR4::hasMatchingComponent;
    }

    @Generated
    protected FDSConfigR4(FDSConfigR4Builder<?, ?> b) {
        super(b);
        this.fromFHIRQuantityUnitToString = b.fromFHIRQuantityUnitToString$set ? b.fromFHIRQuantityUnitToString$value : FDSConfigR4.$default$fromFHIRQuantityUnitToString();
        this.fromCodeableConceptToString = b.fromCodeableConceptToString$set ? b.fromCodeableConceptToString$value : FDSConfigR4.$default$fromCodeableConceptToString();
        this.fromExtensionsToString = b.fromExtensionsToString$set ? b.fromExtensionsToString$value : FDSConfigR4.$default$fromExtensionsToString();
        this.selectDosageAndRateField = b.selectDosageAndRateField$set ? b.selectDosageAndRateField$value : FDSConfigR4.$default$selectDosageAndRateField();
        this.hasMatchingComponent = b.hasMatchingComponent$set ? b.hasMatchingComponent$value : FDSConfigR4.$default$hasMatchingComponent();
    }

    @Generated
    public static FDSConfigR4Builder<?, ?> builder() {
        return new FDSConfigR4BuilderImpl();
    }

    @Generated
    public Function<Quantity, CompletableFuture<String>> getFromFHIRQuantityUnitToString() {
        return this.fromFHIRQuantityUnitToString;
    }

    @Generated
    public Function<CodeableConcept, CompletableFuture<String>> getFromCodeableConceptToString() {
        return this.fromCodeableConceptToString;
    }

    @Generated
    public Function<List<Extension>, CompletableFuture<String>> getFromExtensionsToString() {
        return this.fromExtensionsToString;
    }

    @Generated
    public BiFunction<List<Dosage.DosageDoseAndRateComponent>, DoseAndRateKey, Type> getSelectDosageAndRateField() {
        return this.selectDosageAndRateField;
    }

    @Generated
    public BiFunction<Dosage, Predicate<Dosage.DosageDoseAndRateComponent>, Boolean> getHasMatchingComponent() {
        return this.hasMatchingComponent;
    }

    @Generated
    public static abstract class FDSConfigR4Builder<C extends FDSConfigR4, B extends FDSConfigR4Builder<C, B>>
    extends FDSConfig.FDSConfigBuilder<C, B> {
        @Generated
        private boolean fromFHIRQuantityUnitToString$set;
        @Generated
        private Function<Quantity, CompletableFuture<String>> fromFHIRQuantityUnitToString$value;
        @Generated
        private boolean fromCodeableConceptToString$set;
        @Generated
        private Function<CodeableConcept, CompletableFuture<String>> fromCodeableConceptToString$value;
        @Generated
        private boolean fromExtensionsToString$set;
        @Generated
        private Function<List<Extension>, CompletableFuture<String>> fromExtensionsToString$value;
        @Generated
        private boolean selectDosageAndRateField$set;
        @Generated
        private BiFunction<List<Dosage.DosageDoseAndRateComponent>, DoseAndRateKey, Type> selectDosageAndRateField$value;
        @Generated
        private boolean hasMatchingComponent$set;
        @Generated
        private BiFunction<Dosage, Predicate<Dosage.DosageDoseAndRateComponent>, Boolean> hasMatchingComponent$value;

        @Generated
        public B fromFHIRQuantityUnitToString(Function<Quantity, CompletableFuture<String>> fromFHIRQuantityUnitToString) {
            this.fromFHIRQuantityUnitToString$value = fromFHIRQuantityUnitToString;
            this.fromFHIRQuantityUnitToString$set = true;
            return (B)this.self();
        }

        @Generated
        public B fromCodeableConceptToString(Function<CodeableConcept, CompletableFuture<String>> fromCodeableConceptToString) {
            this.fromCodeableConceptToString$value = fromCodeableConceptToString;
            this.fromCodeableConceptToString$set = true;
            return (B)this.self();
        }

        @Generated
        public B fromExtensionsToString(Function<List<Extension>, CompletableFuture<String>> fromExtensionsToString) {
            this.fromExtensionsToString$value = fromExtensionsToString;
            this.fromExtensionsToString$set = true;
            return (B)this.self();
        }

        @Generated
        public B selectDosageAndRateField(BiFunction<List<Dosage.DosageDoseAndRateComponent>, DoseAndRateKey, Type> selectDosageAndRateField) {
            this.selectDosageAndRateField$value = selectDosageAndRateField;
            this.selectDosageAndRateField$set = true;
            return (B)this.self();
        }

        @Generated
        public B hasMatchingComponent(BiFunction<Dosage, Predicate<Dosage.DosageDoseAndRateComponent>, Boolean> hasMatchingComponent) {
            this.hasMatchingComponent$value = hasMatchingComponent;
            this.hasMatchingComponent$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "FDSConfigR4.FDSConfigR4Builder(super=" + super.toString() + ", fromFHIRQuantityUnitToString$value=" + String.valueOf(this.fromFHIRQuantityUnitToString$value) + ", fromCodeableConceptToString$value=" + String.valueOf(this.fromCodeableConceptToString$value) + ", fromExtensionsToString$value=" + String.valueOf(this.fromExtensionsToString$value) + ", selectDosageAndRateField$value=" + String.valueOf(this.selectDosageAndRateField$value) + ", hasMatchingComponent$value=" + String.valueOf(this.hasMatchingComponent$value) + ")";
        }
    }

    @Generated
    private static final class FDSConfigR4BuilderImpl
    extends FDSConfigR4Builder<FDSConfigR4, FDSConfigR4BuilderImpl> {
        @Generated
        private FDSConfigR4BuilderImpl() {
        }

        @Override
        @Generated
        protected FDSConfigR4BuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FDSConfigR4 build() {
            return new FDSConfigR4(this);
        }
    }
}

