/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.functions;

import io.github.jy95.fds.common.functions.RangeToString;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.QuantityToStringR4;
import java.math.BigDecimal;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Range;

public class RangeToStringR4
implements RangeToString<FDSConfigR4, Range> {
    private RangeToStringR4() {
    }

    public static RangeToStringR4 getInstance() {
        return Holder.INSTANCE;
    }

    public boolean hasUnit(Range range) {
        if (this.hasHigh(range) && QuantityToStringR4.getInstance().hasUnit(range.getHigh())) {
            return true;
        }
        return this.hasLow(range) && QuantityToStringR4.getInstance().hasUnit(range.getLow());
    }

    public CompletableFuture<String> getUnitText(ResourceBundle bundle, FDSConfigR4 config, Range range, boolean hasLow, boolean hasHigh) {
        return QuantityToStringR4.getInstance().enhancedFromUnitToString(config, hasHigh ? range.getHigh() : range.getLow());
    }

    public boolean hasLow(Range range) {
        return range.hasLow();
    }

    public boolean hasHigh(Range range) {
        return range.hasHigh();
    }

    public BigDecimal getLowValue(Range range) {
        return range.getLow().getValue();
    }

    public BigDecimal getHighValue(Range range) {
        return range.getHigh().getValue();
    }

    private static class Holder {
        private static final RangeToStringR4 INSTANCE = new RangeToStringR4();

        private Holder() {
        }
    }
}

