/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.functions;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.functions.RatioToString;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.QuantityToStringR4;
import java.math.BigDecimal;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Ratio;

public class RatioToStringR4
implements RatioToString<FDSConfigR4, Ratio> {
    private RatioToStringR4() {
    }

    public static RatioToStringR4 getInstance() {
        return Holder.INSTANCE;
    }

    public String retrieveRatioLinkWord(ResourceBundle bundle, FDSConfigR4 config, Ratio ratio) {
        BigDecimal denominatorValue;
        boolean hasNumerator = ratio.hasNumerator();
        boolean hasDenominator = ratio.hasDenominator();
        boolean hasNumeratorUnit = hasNumerator && QuantityToStringR4.getInstance().hasUnit(ratio.getNumerator());
        boolean hasBothElements = hasNumerator && hasDenominator;
        boolean hasDenominatorUnit = hasDenominator && QuantityToStringR4.getInstance().hasUnit(ratio.getDenominator());
        boolean hasUnitRatio = hasNumeratorUnit || hasDenominatorUnit;
        BigDecimal bigDecimal = denominatorValue = hasDenominator ? ratio.getDenominator().getValue() : BigDecimal.ONE;
        if (hasUnitRatio && hasBothElements) {
            String linkWordMsg = bundle.getString("amount.ratio.denominatorLinkword");
            return new MessageFormat(linkWordMsg, config.getLocale()).format((Object)new Object[]{denominatorValue});
        }
        return hasBothElements ? ":" : "";
    }

    public boolean hasNumerator(Ratio ratio) {
        return ratio.hasNumerator();
    }

    public CompletableFuture<String> convertNumerator(ResourceBundle bundle, FDSConfigR4 config, Ratio ratio) {
        return QuantityToStringR4.getInstance().convert(bundle, config, ratio.getNumerator());
    }

    public boolean hasDenominator(Ratio ratio) {
        return ratio.hasDenominator();
    }

    public CompletableFuture<String> convertDenominator(ResourceBundle bundle, FDSConfigR4 config, Ratio ratio) {
        Quantity denominator = ratio.getDenominator();
        BigDecimal denominatorValue = denominator.getValue();
        if (!QuantityToStringR4.getInstance().hasUnit(denominator)) {
            return CompletableFuture.completedFuture(denominatorValue.toString());
        }
        if (BigDecimal.ONE.equals(denominatorValue)) {
            return QuantityToStringR4.getInstance().enhancedFromUnitToString(config, denominator);
        }
        return QuantityToStringR4.getInstance().convert(bundle, config, denominator);
    }

    private static class Holder {
        private static final RatioToStringR4 INSTANCE = new RatioToStringR4();

        private Holder() {
        }
    }
}

