/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.functions.ListToString;
import io.github.jy95.fds.common.translators.AsNeeded;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Dosage;

public class AsNeededR4
implements AsNeeded<FDSConfigR4, Dosage> {
    protected final MessageFormat asNeededForMsg;
    protected final String asNeededMsg;
    private final FDSConfigR4 config;
    private final ResourceBundle bundle;

    public AsNeededR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
        this.asNeededForMsg = this.getAsNeededForMsg(bundle, config.getLocale());
        this.asNeededMsg = this.getAsNeededMsg(bundle);
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        if (this.hasCodeableConcepts(dosage)) {
            return this.convertCodeableConcepts(dosage);
        }
        return CompletableFuture.supplyAsync(() -> this.asNeededMsg);
    }

    public boolean isPresent(Dosage dosage) {
        return dosage.hasAsNeeded();
    }

    public boolean hasCodeableConcepts(Dosage dosage) {
        return dosage.hasAsNeededCodeableConcept();
    }

    public CompletableFuture<String> convertCodeableConcepts(Dosage dosage) {
        CodeableConcept code = dosage.getAsNeededCodeableConcept();
        CompletableFuture<String> codeAsText = this.config.fromCodeableConceptToString(code);
        return ((CompletableFuture)codeAsText.thenApplyAsync(v -> ListToString.convert((ResourceBundle)this.bundle, List.of(v)))).thenApplyAsync(v -> this.asNeededForMsg.format((Object)new Object[]{v}));
    }
}

