/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.BoundsDuration;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.QuantityToStringR4;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Duration;

public class BoundsDurationR4
implements BoundsDuration<FDSConfigR4, Dosage> {
    protected final MessageFormat boundsDurationMsg;
    private final FDSConfigR4 config;
    private final ResourceBundle bundle;

    public BoundsDurationR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
        this.boundsDurationMsg = this.getBoundsDurationMsg(bundle, config.getLocale());
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    public boolean hasRequiredElements(Dosage dosage) {
        return dosage.getTiming().hasRepeat() && dosage.getTiming().getRepeat().hasBoundsDuration();
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Duration boundsDuration = dosage.getTiming().getRepeat().getBoundsDuration();
        return QuantityToStringR4.getInstance().convert(this.bundle, this.config, boundsDuration).thenApplyAsync(durationText -> this.boundsDurationMsg.format((Object)new Object[]{durationText}));
    }
}

