/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.BoundsPeriod;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.FormatDateTimesR4;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Period;

public class BoundsPeriodR4
implements BoundsPeriod<FDSConfigR4, Dosage> {
    protected final MessageFormat boundsPeriodMsg;
    private final FDSConfigR4 config;

    public BoundsPeriodR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.config = config;
        this.boundsPeriodMsg = this.getBoundsPeriodMsg(bundle, config.getLocale());
    }

    public boolean hasRequiredElements(Dosage dosage) {
        return dosage.getTiming().hasRepeat() && dosage.getTiming().getRepeat().hasBoundsPeriod();
    }

    public boolean hasStartPeriod(Dosage dosage) {
        return dosage.getTiming().getRepeat().getBoundsPeriod().hasStart();
    }

    public boolean hasEndPeriod(Dosage dosage) {
        return dosage.getTiming().getRepeat().getBoundsPeriod().hasEnd();
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    public String formatStartPeriod(Dosage dosage) {
        Period boundPeriods = dosage.getTiming().getRepeat().getBoundsPeriod();
        Locale locale = this.config.getLocale();
        return FormatDateTimesR4.getInstance().convert(locale, boundPeriods.getStartElement());
    }

    public String formatEndPeriod(Dosage dosage) {
        Locale locale = this.config.getLocale();
        Period boundPeriods = dosage.getTiming().getRepeat().getBoundsPeriod();
        return FormatDateTimesR4.getInstance().convert(locale, boundPeriods.getEndElement());
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        return CompletableFuture.supplyAsync(() -> {
            Map arguments = this.extractInformation(dosage);
            return this.boundsPeriodMsg.format((Object)arguments);
        });
    }
}

