/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.BoundsRange;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.RangeToStringR4;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Range;

public class BoundsRangeR4
implements BoundsRange<FDSConfigR4, Dosage> {
    protected final MessageFormat boundsRangeMsg;
    private final FDSConfigR4 config;
    private final ResourceBundle bundle;

    public BoundsRangeR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
        this.boundsRangeMsg = this.getBoundsRangeMsg(bundle, config.getLocale());
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Range boundsRange = dosage.getTiming().getRepeat().getBoundsRange();
        return RangeToStringR4.getInstance().convert(this.bundle, this.config, boundsRange).thenApplyAsync(v -> this.boundsRangeMsg.format((Object)new Object[]{v}));
    }

    public boolean hasRequiredElements(Dosage dosage) {
        return dosage.getTiming().hasRepeat() && dosage.getTiming().getRepeat().hasBoundsRange();
    }
}

