/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.CountCountMax;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Dosage;

public class CountCountMaxR4
implements CountCountMax<FDSConfigR4, Dosage> {
    protected final MessageFormat countMaxMsg;
    protected final MessageFormat countMsg;

    public CountCountMaxR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.countMaxMsg = this.getCountMaxMsg(bundle, config.getLocale());
        this.countMsg = this.getCountMsg(bundle, config.getLocale());
    }

    public boolean hasRequiredElements(Dosage dosage) {
        return dosage.getTiming().hasRepeat() && (dosage.getTiming().getRepeat().hasCount() || this.hasCountMax(dosage));
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    public boolean hasCountMax(Dosage dosage) {
        return dosage.getTiming().getRepeat().hasCountMax();
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.hasCountMax(dosage)) {
                Map<String, Integer> arguments = Map.of("minCount", dosage.getTiming().getRepeat().getCount(), "maxCount", dosage.getTiming().getRepeat().getCountMax());
                return this.countMaxMsg.format(arguments);
            }
            return this.countMsg.format((Object)new Object[]{dosage.getTiming().getRepeat().getCount()});
        });
    }
}

