/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.functions.DayOfWeekFormatter;
import io.github.jy95.fds.common.functions.ListToString;
import io.github.jy95.fds.common.translators.DayOfWeek;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Dosage;

public class DayOfWeekR4
implements DayOfWeek<FDSConfigR4, Dosage> {
    protected final MessageFormat dayOfWeekMsg;
    private final DayOfWeekFormatter dayOfWeekFormatter;
    private final ResourceBundle bundle;

    public DayOfWeekR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.bundle = bundle;
        this.dayOfWeekMsg = this.getDayOfWeekMsg(bundle, config.getLocale());
        this.dayOfWeekFormatter = new DayOfWeekFormatter(config.getLocale());
    }

    public boolean hasRequiredElements(Dosage dosage) {
        return dosage.getTiming().hasRepeat() && dosage.getTiming().getRepeat().hasDayOfWeek();
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        return CompletableFuture.supplyAsync(() -> {
            List dayOfWeeks = dosage.getTiming().getRepeat().getDayOfWeek();
            List<String> dayOfWeeksCodes = dayOfWeeks.stream().map(day -> this.dayOfWeekFormatter.codeToLongText(day.getCode().toLowerCase())).collect(Collectors.toList());
            return this.daysToText(dayOfWeeksCodes);
        });
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    private String daysToText(List<String> days) {
        String dayOfWeeksAsString = ListToString.convert((ResourceBundle)this.bundle, days);
        Map<String, String> messageArguments = Map.of("dayCondition", days.size(), "day", dayOfWeeksAsString);
        return this.dayOfWeekMsg.format(messageArguments);
    }
}

