/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import io.github.jy95.fds.common.types.DoseAndRateKey;
import io.github.jy95.fds.common.types.Translator;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.QuantityToStringR4;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Type;

public class DoseQuantityR4
implements Translator<FDSConfigR4, Dosage> {
    private final FDSConfigR4 config;
    private final ResourceBundle bundle;

    public DoseQuantityR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Type doseQuantity = this.config.selectDosageAndRateField((List<Dosage.DosageDoseAndRateComponent>)dosage.getDoseAndRate(), DoseAndRateKey.DOSE_QUANTITY);
        return QuantityToStringR4.getInstance().convert(this.bundle, this.config, (Quantity)doseQuantity);
    }

    public boolean isPresent(Dosage dosage) {
        return this.config.hasMatchingComponent(dosage, Dosage.DosageDoseAndRateComponent::hasDoseQuantity);
    }
}

