/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import io.github.jy95.fds.common.types.DoseAndRateKey;
import io.github.jy95.fds.common.types.Translator;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.RangeToStringR4;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Type;

public class DoseRangeR4
implements Translator<FDSConfigR4, Dosage> {
    private final FDSConfigR4 config;
    private final ResourceBundle bundle;

    public DoseRangeR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Type doseRange = this.config.selectDosageAndRateField((List<Dosage.DosageDoseAndRateComponent>)dosage.getDoseAndRate(), DoseAndRateKey.DOSE_RANGE);
        return RangeToStringR4.getInstance().convert(this.bundle, this.config, (Range)doseRange);
    }

    public boolean isPresent(Dosage dosage) {
        return this.config.hasMatchingComponent(dosage, Dosage.DosageDoseAndRateComponent::hasDoseRange);
    }
}

