/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.functions.UnitsOfTimeFormatter;
import io.github.jy95.fds.common.translators.DurationDurationMax;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.ResourceBundle;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Timing;

public class DurationDurationMaxR4
implements DurationDurationMax<FDSConfigR4, Dosage> {
    protected final MessageFormat durationMsg;
    protected final MessageFormat durationMaxMsg;
    private final Locale locale;

    public DurationDurationMaxR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.locale = config.getLocale();
        this.durationMsg = this.getDurationMsg(bundle, this.locale);
        this.durationMaxMsg = this.getDurationMaxMsg(bundle, this.locale);
    }

    public boolean hasDuration(Dosage dosage) {
        return dosage.getTiming().getRepeat().hasDuration();
    }

    public boolean hasDurationMax(Dosage dosage) {
        return dosage.getTiming().getRepeat().hasDurationMax();
    }

    public boolean hasRequiredElements(Dosage dosage) {
        return dosage.getTiming().hasRepeat() && dosage.getTiming().getRepeat().hasDurationUnit() && (this.hasDuration(dosage) || this.hasDurationMax(dosage));
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    public String turnDurationToString(Dosage dosage) {
        Timing.TimingRepeatComponent repeat = dosage.getTiming().getRepeat();
        String durationUnit = repeat.getDurationUnit().toCode();
        BigDecimal durationQuantity = repeat.getDuration();
        String durationText = UnitsOfTimeFormatter.formatWithCount((Locale)this.locale, (String)durationUnit, (Number)durationQuantity);
        return this.durationMsg.format((Object)new Object[]{durationText});
    }

    public String turnDurationMaxToString(Dosage dosage) {
        Timing.TimingRepeatComponent repeat = dosage.getTiming().getRepeat();
        String durationUnit = repeat.getDurationUnit().toCode();
        BigDecimal durationQuantity = repeat.getDurationMax();
        String durationText = UnitsOfTimeFormatter.formatWithCount((Locale)this.locale, (String)durationUnit, (Number)durationQuantity);
        return this.durationMaxMsg.format((Object)new Object[]{durationText});
    }
}

