/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.FrequencyFrequencyMax;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Timing;

public class FrequencyFrequencyMaxR4
implements FrequencyFrequencyMax<FDSConfigR4, Dosage> {
    protected final MessageFormat frequencyAndFrequencyMaxMsg;
    protected final MessageFormat frequencyMaxMsg;
    protected final MessageFormat frequencyMsg;

    public FrequencyFrequencyMaxR4(FDSConfigR4 config, ResourceBundle bundle) {
        Locale locale = config.getLocale();
        this.frequencyAndFrequencyMaxMsg = this.getFrequencyAndFrequencyMaxMsg(bundle, locale);
        this.frequencyMaxMsg = this.getFrequencyMaxMsg(bundle, locale);
        this.frequencyMsg = this.getFrequencyMsg(bundle, locale);
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    public String formatFrequencyAndFrequencyMaxText(int frequencyMin, int frequencyMax) {
        Map<String, Integer> arguments = Map.of("frequency", frequencyMin, "maxFrequency", frequencyMax);
        return this.frequencyAndFrequencyMaxMsg.format(arguments);
    }

    public String formatFrequencyMaxText(int frequencyMax) {
        return this.frequencyMaxMsg.format((Object)new Object[]{frequencyMax});
    }

    public String formatFrequencyText(int frequency) {
        return this.frequencyMsg.format((Object)new Object[]{frequency});
    }

    public boolean hasFrequency(Dosage dosage) {
        return dosage.getTiming().getRepeat().hasFrequency();
    }

    public boolean hasFrequencyMax(Dosage dosage) {
        return dosage.getTiming().getRepeat().hasFrequencyMax();
    }

    public boolean hasRequiredElements(Dosage dosage) {
        return dosage.getTiming().hasRepeat() && (this.hasFrequency(dosage) || this.hasFrequencyMax(dosage));
    }

    public String turnFrequencyAndFrequencyMaxToString(Dosage dosage) {
        Timing.TimingRepeatComponent repeat = dosage.getTiming().getRepeat();
        int frequencyMin = repeat.getFrequency();
        int frequencyMax = repeat.getFrequencyMax();
        return this.formatFrequencyAndFrequencyMaxText(frequencyMin, frequencyMax);
    }

    public String turnFrequencyMaxToString(Dosage dosage) {
        Timing.TimingRepeatComponent repeat = dosage.getTiming().getRepeat();
        int frequencyMax = repeat.getFrequencyMax();
        return this.formatFrequencyMaxText(frequencyMax);
    }

    public String turnFrequencyToString(Dosage dosage) {
        Timing.TimingRepeatComponent repeat = dosage.getTiming().getRepeat();
        int frequency = repeat.getFrequency();
        return this.formatFrequencyText(frequency);
    }
}

