/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.MaxDosePerAdministration;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.QuantityToStringR4;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Quantity;

public class MaxDosePerAdministrationR4
implements MaxDosePerAdministration<FDSConfigR4, Dosage> {
    protected final MessageFormat maxDosePerAdministrationMsg;
    private final FDSConfigR4 config;
    private final ResourceBundle bundle;

    public MaxDosePerAdministrationR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.bundle = bundle;
        this.config = config;
        this.maxDosePerAdministrationMsg = this.getMaxDosePerAdministrationMsg(bundle, config.getLocale());
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Quantity quantity = dosage.getMaxDosePerAdministration();
        return QuantityToStringR4.getInstance().convert(this.bundle, this.config, quantity).thenApplyAsync(quantityText -> this.maxDosePerAdministrationMsg.format((Object)new Object[]{quantityText}));
    }

    public boolean isPresent(Dosage dosage) {
        return dosage.hasMaxDosePerAdministration();
    }
}

