/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.MaxDosePerPeriod;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.RatioToStringR4;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Ratio;

public class MaxDosePerPeriodR4
implements MaxDosePerPeriod<FDSConfigR4, Dosage> {
    protected final MessageFormat maxDosePerPeriodMsg;
    private final FDSConfigR4 config;
    private final ResourceBundle bundle;

    public MaxDosePerPeriodR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.bundle = bundle;
        this.config = config;
        this.maxDosePerPeriodMsg = this.getMaxDosePerPeriodMsg(bundle, config.getLocale());
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Ratio ratio = dosage.getMaxDosePerPeriod();
        return RatioToStringR4.getInstance().convert(this.bundle, this.config, ratio).thenApplyAsync(ratioText -> this.maxDosePerPeriodMsg.format((Object)new Object[]{ratioText}));
    }

    public boolean isPresent(Dosage dosage) {
        return dosage.hasMaxDosePerPeriod();
    }
}

