/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.RateQuantity;
import io.github.jy95.fds.common.types.DoseAndRateKey;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.QuantityToStringR4;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Type;

public class RateQuantityR4
implements RateQuantity<FDSConfigR4, Dosage> {
    protected final MessageFormat rateQuantityMsg;
    private final FDSConfigR4 config;
    private final ResourceBundle bundle;

    public RateQuantityR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
        this.rateQuantityMsg = this.getRateQuantityMsg(bundle, config.getLocale());
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Type rateQuantity = this.config.selectDosageAndRateField((List<Dosage.DosageDoseAndRateComponent>)dosage.getDoseAndRate(), DoseAndRateKey.RATE_QUANTITY);
        return QuantityToStringR4.getInstance().convert(this.bundle, this.config, (Quantity)rateQuantity).thenApplyAsync(rateQuantityText -> this.rateQuantityMsg.format((Object)new Object[]{rateQuantityText}));
    }

    public boolean isPresent(Dosage dosage) {
        return this.config.hasMatchingComponent(dosage, Dosage.DosageDoseAndRateComponent::hasRateQuantity);
    }
}

