/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.RateRange;
import io.github.jy95.fds.common.types.DoseAndRateKey;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.RangeToStringR4;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Type;

public class RateRangeR4
implements RateRange<FDSConfigR4, Dosage> {
    protected final MessageFormat rateRangeMsg;
    private final FDSConfigR4 config;
    private final ResourceBundle bundle;

    public RateRangeR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
        this.rateRangeMsg = this.getRateRangeMsg(bundle, config.getLocale());
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Type rateRange = this.config.selectDosageAndRateField((List<Dosage.DosageDoseAndRateComponent>)dosage.getDoseAndRate(), DoseAndRateKey.RATE_RANGE);
        return RangeToStringR4.getInstance().convert(this.bundle, this.config, (Range)rateRange).thenApplyAsync(rateRatioText -> this.rateRangeMsg.format((Object)new Object[]{rateRatioText}));
    }

    public boolean isPresent(Dosage dosage) {
        return this.config.hasMatchingComponent(dosage, Dosage.DosageDoseAndRateComponent::hasRateRange);
    }
}

