/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.translators.RateRatio;
import io.github.jy95.fds.common.types.DoseAndRateKey;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.RatioToStringR4;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Type;

public class RateRatioR4
implements RateRatio<FDSConfigR4, Dosage> {
    protected final MessageFormat rateRatioMsg;
    private final FDSConfigR4 config;
    private final ResourceBundle bundle;

    public RateRatioR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
        this.rateRatioMsg = this.getRateRatioMsg(bundle, config.getLocale());
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        Type rateRatio = this.config.selectDosageAndRateField((List<Dosage.DosageDoseAndRateComponent>)dosage.getDoseAndRate(), DoseAndRateKey.RATE_RATIO);
        return RatioToStringR4.getInstance().convert(this.bundle, this.config, (Ratio)rateRatio).thenApplyAsync(rateRatioText -> this.rateRatioMsg.format((Object)new Object[]{rateRatioText}));
    }

    public boolean isPresent(Dosage dosage) {
        return this.config.hasMatchingComponent(dosage, Dosage.DosageDoseAndRateComponent::hasRateRatio);
    }
}

