/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.functions.ListToString;
import io.github.jy95.fds.common.translators.TimeOfDay;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Timing;

public class TimeOfDayR4
implements TimeOfDay<FDSConfigR4, Dosage> {
    protected final MessageFormat timeOfDayMsg;
    private final ResourceBundle bundle;

    public TimeOfDayR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.timeOfDayMsg = this.getTimeOfDayMsg(bundle, config.getLocale());
        this.bundle = bundle;
    }

    public List<String> getTimes(Dosage dosage) {
        return dosage.getTiming().getRepeat().getTimeOfDay().stream().map(PrimitiveType::getValue).collect(Collectors.toList());
    }

    public boolean hasRequiredElements(Dosage dosage) {
        Timing timing = dosage.getTiming();
        return timing.hasRepeat() && timing.getRepeat().hasTimeOfDay();
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        return CompletableFuture.supplyAsync(() -> {
            List<String> times = this.getTimes(dosage);
            List timeOfDays = times.stream().map(arg_0 -> ((TimeOfDayR4)this).formatString(arg_0)).collect(Collectors.toList());
            String timeOfDaysAsString = ListToString.convert((ResourceBundle)this.bundle, timeOfDays);
            Map<String, Integer> messageArguments = Map.of("timeOfDay", timeOfDaysAsString, "count", timeOfDays.size());
            return this.timeOfDayMsg.format(messageArguments);
        });
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }
}

