/*
 * Decompiled with CFR 0.152.
 */
package io.github.jy95.fds.r4.translators;

import com.ibm.icu.text.MessageFormat;
import io.github.jy95.fds.common.functions.ListToString;
import io.github.jy95.fds.common.translators.TimingEvent;
import io.github.jy95.fds.r4.config.FDSConfigR4;
import io.github.jy95.fds.r4.functions.FormatDateTimesR4;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.hl7.fhir.r4.model.Dosage;

public class TimingEventR4
implements TimingEvent<FDSConfigR4, Dosage> {
    protected final MessageFormat timingEventMsg;
    private final FDSConfigR4 config;
    private final ResourceBundle bundle;

    public TimingEventR4(FDSConfigR4 config, ResourceBundle bundle) {
        this.config = config;
        this.bundle = bundle;
        this.timingEventMsg = this.getTimingEventMsg(bundle, config.getLocale());
    }

    public boolean hasRequiredElements(Dosage dosage) {
        return dosage.getTiming().hasEvent();
    }

    public List<String> getEvents(Dosage dosage) {
        List events = dosage.getTiming().getEvent();
        return FormatDateTimesR4.getInstance().convert(this.config.getLocale(), events);
    }

    public boolean hasTiming(Dosage dosage) {
        return dosage.hasTiming();
    }

    public CompletableFuture<String> convert(Dosage dosage) {
        return CompletableFuture.supplyAsync(() -> {
            List<String> eventsList = this.getEvents(dosage);
            String eventsAsString = ListToString.convert((ResourceBundle)this.bundle, eventsList);
            Map<String, String> arguments = Map.of("eventCondition", eventsList.size(), "event", eventsAsString);
            return this.timingEventMsg.format(arguments);
        });
    }
}

